package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WirelessDeviceEventLogOption(
    event: zio.aws.iotwireless.model.WirelessDeviceEvent,
    logLevel: zio.aws.iotwireless.model.LogLevel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEventLogOption = {
    import WirelessDeviceEventLogOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEventLogOption
      .builder()
      .event(event.unwrap)
      .logLevel(logLevel.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.WirelessDeviceEventLogOption.ReadOnly =
    zio.aws.iotwireless.model.WirelessDeviceEventLogOption.wrap(buildAwsValue())
}
object WirelessDeviceEventLogOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEventLogOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WirelessDeviceEventLogOption =
      zio.aws.iotwireless.model.WirelessDeviceEventLogOption(event, logLevel)
    def event: zio.aws.iotwireless.model.WirelessDeviceEvent
    def logLevel: zio.aws.iotwireless.model.LogLevel
    def getEvent
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.WirelessDeviceEvent] =
      ZIO.succeed(event)
    def getLogLevel: ZIO[Any, Nothing, zio.aws.iotwireless.model.LogLevel] =
      ZIO.succeed(logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEventLogOption
  ) extends zio.aws.iotwireless.model.WirelessDeviceEventLogOption.ReadOnly {
    override val event: zio.aws.iotwireless.model.WirelessDeviceEvent =
      zio.aws.iotwireless.model.WirelessDeviceEvent.wrap(impl.event())
    override val logLevel: zio.aws.iotwireless.model.LogLevel =
      zio.aws.iotwireless.model.LogLevel.wrap(impl.logLevel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEventLogOption
  ): zio.aws.iotwireless.model.WirelessDeviceEventLogOption.ReadOnly =
    new Wrapper(impl)
}
