package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.UpdateDataSource
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateWirelessGatewayTaskCreate(
    updateDataSource: Option[UpdateDataSource] = None,
    updateDataRole: Option[UpdateDataSource] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskCreate = {
    import UpdateWirelessGatewayTaskCreate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskCreate
      .builder()
      .optionallyWith(
        updateDataSource.map(value =>
          UpdateDataSource.unwrap(value): java.lang.String
        )
      )(_.updateDataSource)
      .optionallyWith(
        updateDataRole.map(value =>
          UpdateDataSource.unwrap(value): java.lang.String
        )
      )(_.updateDataRole)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.ReadOnly =
    zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate
      .wrap(buildAwsValue())
}
object UpdateWirelessGatewayTaskCreate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskCreate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate =
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate(
        updateDataSource.map(value => value),
        updateDataRole.map(value => value),
        loRaWAN.map(value => value.asEditable)
      )
    def updateDataSource: Option[UpdateDataSource]
    def updateDataRole: Option[UpdateDataSource]
    def loRaWAN: Option[
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate.ReadOnly
    ]
    def getUpdateDataSource: ZIO[Any, AwsError, UpdateDataSource] =
      AwsError.unwrapOptionField("updateDataSource", updateDataSource)
    def getUpdateDataRole: ZIO[Any, AwsError, UpdateDataSource] =
      AwsError.unwrapOptionField("updateDataRole", updateDataRole)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskCreate
  ) extends zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.ReadOnly {
    override val updateDataSource: Option[UpdateDataSource] = scala
      .Option(impl.updateDataSource())
      .map(value =>
        zio.aws.iotwireless.model.primitives.UpdateDataSource(value)
      )
    override val updateDataRole: Option[UpdateDataSource] = scala
      .Option(impl.updateDataRole())
      .map(value =>
        zio.aws.iotwireless.model.primitives.UpdateDataSource(value)
      )
    override val loRaWAN: Option[
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate.ReadOnly
    ] = scala
      .Option(impl.loRaWAN())
      .map(value =>
        zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskCreate
  ): zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.ReadOnly =
    new Wrapper(impl)
}
