package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateLogLevelsByResourceTypesRequest(
    defaultLogLevel: Option[zio.aws.iotwireless.model.LogLevel] = None,
    wirelessDeviceLogOptions: Option[
      Iterable[zio.aws.iotwireless.model.WirelessDeviceLogOption]
    ] = None,
    wirelessGatewayLogOptions: Option[
      Iterable[zio.aws.iotwireless.model.WirelessGatewayLogOption]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest = {
    import UpdateLogLevelsByResourceTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
      .builder()
      .optionallyWith(defaultLogLevel.map(value => value.unwrap))(
        _.defaultLogLevel
      )
      .optionallyWith(
        wirelessDeviceLogOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wirelessDeviceLogOptions)
      .optionallyWith(
        wirelessGatewayLogOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wirelessGatewayLogOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
      .wrap(buildAwsValue())
}
object UpdateLogLevelsByResourceTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest =
      zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest(
        defaultLogLevel.map(value => value),
        wirelessDeviceLogOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        wirelessGatewayLogOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def defaultLogLevel: Option[zio.aws.iotwireless.model.LogLevel]
    def wirelessDeviceLogOptions: Option[
      List[zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly]
    ]
    def wirelessGatewayLogOptions: Option[
      List[zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly]
    ]
    def getDefaultLogLevel
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.LogLevel] =
      AwsError.unwrapOptionField("defaultLogLevel", defaultLogLevel)
    def getWirelessDeviceLogOptions: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "wirelessDeviceLogOptions",
      wirelessDeviceLogOptions
    )
    def getWirelessGatewayLogOptions: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "wirelessGatewayLogOptions",
      wirelessGatewayLogOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
  ) extends zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest.ReadOnly {
    override val defaultLogLevel: Option[zio.aws.iotwireless.model.LogLevel] =
      scala
        .Option(impl.defaultLogLevel())
        .map(value => zio.aws.iotwireless.model.LogLevel.wrap(value))
    override val wirelessDeviceLogOptions: Option[
      List[zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly]
    ] = scala
      .Option(impl.wirelessDeviceLogOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessDeviceLogOption.wrap(item)
        }.toList
      )
    override val wirelessGatewayLogOptions: Option[
      List[zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly]
    ] = scala
      .Option(impl.wirelessGatewayLogOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessGatewayLogOption.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
  ): zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest.ReadOnly =
    new Wrapper(impl)
}
