package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  FirmwareUpdateRole,
  FirmwareUpdateImage,
  FuotaTaskName,
  Description,
  FuotaTaskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFuotaTaskRequest(
    id: FuotaTaskId,
    name: Option[FuotaTaskName] = None,
    description: Option[Description] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANFuotaTask] = None,
    firmwareUpdateImage: Option[FirmwareUpdateImage] = None,
    firmwareUpdateRole: Option[FirmwareUpdateRole] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest = {
    import UpdateFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest
      .builder()
      .id(FuotaTaskId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => FuotaTaskName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        firmwareUpdateImage.map(value =>
          FirmwareUpdateImage.unwrap(value): java.lang.String
        )
      )(_.firmwareUpdateImage)
      .optionallyWith(
        firmwareUpdateRole.map(value =>
          FirmwareUpdateRole.unwrap(value): java.lang.String
        )
      )(_.firmwareUpdateRole)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.UpdateFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateFuotaTaskRequest.wrap(buildAwsValue())
}
object UpdateFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateFuotaTaskRequest =
      zio.aws.iotwireless.model.UpdateFuotaTaskRequest(
        id,
        name.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable),
        firmwareUpdateImage.map(value => value),
        firmwareUpdateRole.map(value => value)
      )
    def id: FuotaTaskId
    def name: Option[FuotaTaskName]
    def description: Option[Description]
    def loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly]
    def firmwareUpdateImage: Option[FirmwareUpdateImage]
    def firmwareUpdateRole: Option[FirmwareUpdateRole]
    def getId: ZIO[Any, Nothing, FuotaTaskId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, FuotaTaskName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getFirmwareUpdateImage: ZIO[Any, AwsError, FirmwareUpdateImage] =
      AwsError.unwrapOptionField("firmwareUpdateImage", firmwareUpdateImage)
    def getFirmwareUpdateRole: ZIO[Any, AwsError, FirmwareUpdateRole] =
      AwsError.unwrapOptionField("firmwareUpdateRole", firmwareUpdateRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.UpdateFuotaTaskRequest.ReadOnly {
    override val id: FuotaTaskId =
      zio.aws.iotwireless.model.primitives.FuotaTaskId(impl.id())
    override val name: Option[FuotaTaskName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly] = scala
      .Option(impl.loRaWAN())
      .map(value => zio.aws.iotwireless.model.LoRaWANFuotaTask.wrap(value))
    override val firmwareUpdateImage: Option[FirmwareUpdateImage] = scala
      .Option(impl.firmwareUpdateImage())
      .map(value =>
        zio.aws.iotwireless.model.primitives.FirmwareUpdateImage(value)
      )
    override val firmwareUpdateRole: Option[FirmwareUpdateRole] = scala
      .Option(impl.firmwareUpdateRole())
      .map(value =>
        zio.aws.iotwireless.model.primitives.FirmwareUpdateRole(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest
  ): zio.aws.iotwireless.model.UpdateFuotaTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
