package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait SupportedRfRegion {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion
}
object SupportedRfRegion {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion
  ): zio.aws.iotwireless.model.SupportedRfRegion = value match {
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.EU868 =>
      val r = EU868
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.US915 =>
      val r = US915
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AU915 =>
      val r = AU915
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AS923_1 =>
      val r = `AS923-1`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.UNKNOWN_TO_SDK_VERSION
  }
  case object EU868 extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.EU868
  }
  case object US915 extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.US915
  }
  case object AU915 extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AU915
  }
  case object `AS923-1` extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AS923_1
  }
}
