package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.FuotaTaskId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartFuotaTaskRequest(
    id: FuotaTaskId,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANStartFuotaTask] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.StartFuotaTaskRequest = {
    import StartFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.StartFuotaTaskRequest
      .builder()
      .id(FuotaTaskId.unwrap(id): java.lang.String)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.StartFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.StartFuotaTaskRequest.wrap(buildAwsValue())
}
object StartFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.StartFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.StartFuotaTaskRequest =
      zio.aws.iotwireless.model
        .StartFuotaTaskRequest(id, loRaWAN.map(value => value.asEditable))
    def id: FuotaTaskId
    def loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANStartFuotaTask.ReadOnly]
    def getId: ZIO[Any, Nothing, FuotaTaskId] = ZIO.succeed(id)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANStartFuotaTask.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.StartFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.StartFuotaTaskRequest.ReadOnly {
    override val id: FuotaTaskId =
      zio.aws.iotwireless.model.primitives.FuotaTaskId(impl.id())
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANStartFuotaTask.ReadOnly] =
      scala
        .Option(impl.loRaWAN())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANStartFuotaTask.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.StartFuotaTaskRequest
  ): zio.aws.iotwireless.model.StartFuotaTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
