package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{QueryString, MulticastGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest(
    id: MulticastGroupId,
    queryString: Option[QueryString] = None,
    tags: Option[Iterable[zio.aws.iotwireless.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest = {
    import StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest
      .builder()
      .id(MulticastGroupId.unwrap(id): java.lang.String)
      .optionallyWith(
        queryString.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.queryString)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.ReadOnly =
    zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest
      .wrap(buildAwsValue())
}
object StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest =
      zio.aws.iotwireless.model
        .StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest(
          id,
          queryString.map(value => value),
          tags.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def id: MulticastGroupId
    def queryString: Option[QueryString]
    def tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def getId: ZIO[Any, Nothing, MulticastGroupId] = ZIO.succeed(id)
    def getQueryString: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest
  ) extends zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.ReadOnly {
    override val id: MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId(impl.id())
    override val queryString: Option[QueryString] = scala
      .Option(impl.queryString())
      .map(value => zio.aws.iotwireless.model.primitives.QueryString(value))
    override val tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest
  ): zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.ReadOnly =
    new Wrapper(impl)
}
