package zio.aws.iotwireless.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SidewalkSendDataToDevice(
    seq: Option[zio.aws.iotwireless.model.primitives.Seq] = None,
    messageType: Option[zio.aws.iotwireless.model.MessageType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkSendDataToDevice = {
    import SidewalkSendDataToDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkSendDataToDevice
      .builder()
      .optionallyWith(
        seq.map(value =>
          zio.aws.iotwireless.model.primitives.Seq.unwrap(value): Integer
        )
      )(_.seq)
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SidewalkSendDataToDevice.ReadOnly =
    zio.aws.iotwireless.model.SidewalkSendDataToDevice.wrap(buildAwsValue())
}
object SidewalkSendDataToDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkSendDataToDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkSendDataToDevice =
      zio.aws.iotwireless.model.SidewalkSendDataToDevice(
        seq.map(value => value),
        messageType.map(value => value)
      )
    def seq: Option[zio.aws.iotwireless.model.primitives.Seq]
    def messageType: Option[zio.aws.iotwireless.model.MessageType]
    def getSeq: ZIO[Any, AwsError, zio.aws.iotwireless.model.primitives.Seq] =
      AwsError.unwrapOptionField("seq", seq)
    def getMessageType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkSendDataToDevice
  ) extends zio.aws.iotwireless.model.SidewalkSendDataToDevice.ReadOnly {
    override val seq: Option[zio.aws.iotwireless.model.primitives.Seq] = scala
      .Option(impl.seq())
      .map(value => zio.aws.iotwireless.model.primitives.Seq(value))
    override val messageType: Option[zio.aws.iotwireless.model.MessageType] =
      scala
        .Option(impl.messageType())
        .map(value => zio.aws.iotwireless.model.MessageType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkSendDataToDevice
  ): zio.aws.iotwireless.model.SidewalkSendDataToDevice.ReadOnly = new Wrapper(
    impl
  )
}
