package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  SidewalkManufacturingSn,
  SidewalkId,
  AmazonId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SidewalkDevice(
    amazonId: Option[AmazonId] = None,
    sidewalkId: Option[SidewalkId] = None,
    sidewalkManufacturingSn: Option[SidewalkManufacturingSn] = None,
    deviceCertificates: Option[
      Iterable[zio.aws.iotwireless.model.CertificateList]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkDevice = {
    import SidewalkDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkDevice
      .builder()
      .optionallyWith(
        amazonId.map(value => AmazonId.unwrap(value): java.lang.String)
      )(_.amazonId)
      .optionallyWith(
        sidewalkId.map(value => SidewalkId.unwrap(value): java.lang.String)
      )(_.sidewalkId)
      .optionallyWith(
        sidewalkManufacturingSn.map(value =>
          SidewalkManufacturingSn.unwrap(value): java.lang.String
        )
      )(_.sidewalkManufacturingSn)
      .optionallyWith(
        deviceCertificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deviceCertificates)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SidewalkDevice.ReadOnly =
    zio.aws.iotwireless.model.SidewalkDevice.wrap(buildAwsValue())
}
object SidewalkDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkDevice =
      zio.aws.iotwireless.model.SidewalkDevice(
        amazonId.map(value => value),
        sidewalkId.map(value => value),
        sidewalkManufacturingSn.map(value => value),
        deviceCertificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def amazonId: Option[AmazonId]
    def sidewalkId: Option[SidewalkId]
    def sidewalkManufacturingSn: Option[SidewalkManufacturingSn]
    def deviceCertificates
        : Option[List[zio.aws.iotwireless.model.CertificateList.ReadOnly]]
    def getAmazonId: ZIO[Any, AwsError, AmazonId] =
      AwsError.unwrapOptionField("amazonId", amazonId)
    def getSidewalkId: ZIO[Any, AwsError, SidewalkId] =
      AwsError.unwrapOptionField("sidewalkId", sidewalkId)
    def getSidewalkManufacturingSn
        : ZIO[Any, AwsError, SidewalkManufacturingSn] = AwsError
      .unwrapOptionField("sidewalkManufacturingSn", sidewalkManufacturingSn)
    def getDeviceCertificates: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.CertificateList.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceCertificates", deviceCertificates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkDevice
  ) extends zio.aws.iotwireless.model.SidewalkDevice.ReadOnly {
    override val amazonId: Option[AmazonId] = scala
      .Option(impl.amazonId())
      .map(value => zio.aws.iotwireless.model.primitives.AmazonId(value))
    override val sidewalkId: Option[SidewalkId] = scala
      .Option(impl.sidewalkId())
      .map(value => zio.aws.iotwireless.model.primitives.SidewalkId(value))
    override val sidewalkManufacturingSn: Option[SidewalkManufacturingSn] =
      scala
        .Option(impl.sidewalkManufacturingSn())
        .map(value =>
          zio.aws.iotwireless.model.primitives.SidewalkManufacturingSn(value)
        )
    override val deviceCertificates
        : Option[List[zio.aws.iotwireless.model.CertificateList.ReadOnly]] =
      scala
        .Option(impl.deviceCertificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.CertificateList.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkDevice
  ): zio.aws.iotwireless.model.SidewalkDevice.ReadOnly = new Wrapper(impl)
}
