package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{AppSKey, NwkSKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SessionKeysAbpV1_0_x(
    nwkSKey: Option[NwkSKey] = None,
    appSKey: Option[AppSKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_0_x = {
    import SessionKeysAbpV1_0_x.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_0_x
      .builder()
      .optionallyWith(
        nwkSKey.map(value => NwkSKey.unwrap(value): java.lang.String)
      )(_.nwkSKey)
      .optionallyWith(
        appSKey.map(value => AppSKey.unwrap(value): java.lang.String)
      )(_.appSKey)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SessionKeysAbpV1_0_x.ReadOnly =
    zio.aws.iotwireless.model.SessionKeysAbpV1_0_x.wrap(buildAwsValue())
}
object SessionKeysAbpV1_0_x {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_0_x
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SessionKeysAbpV1_0_x =
      zio.aws.iotwireless.model.SessionKeysAbpV1_0_x(
        nwkSKey.map(value => value),
        appSKey.map(value => value)
      )
    def nwkSKey: Option[NwkSKey]
    def appSKey: Option[AppSKey]
    def getNwkSKey: ZIO[Any, AwsError, NwkSKey] =
      AwsError.unwrapOptionField("nwkSKey", nwkSKey)
    def getAppSKey: ZIO[Any, AwsError, AppSKey] =
      AwsError.unwrapOptionField("appSKey", appSKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_0_x
  ) extends zio.aws.iotwireless.model.SessionKeysAbpV1_0_x.ReadOnly {
    override val nwkSKey: Option[NwkSKey] = scala
      .Option(impl.nwkSKey())
      .map(value => zio.aws.iotwireless.model.primitives.NwkSKey(value))
    override val appSKey: Option[AppSKey] = scala
      .Option(impl.appSKey())
      .map(value => zio.aws.iotwireless.model.primitives.AppSKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_0_x
  ): zio.aws.iotwireless.model.SessionKeysAbpV1_0_x.ReadOnly = new Wrapper(impl)
}
