package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.MessageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SendDataToWirelessDeviceResponse(
    messageId: Option[MessageId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceResponse = {
    import SendDataToWirelessDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceResponse
      .builder()
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.SendDataToWirelessDeviceResponse.ReadOnly =
    zio.aws.iotwireless.model.SendDataToWirelessDeviceResponse
      .wrap(buildAwsValue())
}
object SendDataToWirelessDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SendDataToWirelessDeviceResponse =
      zio.aws.iotwireless.model
        .SendDataToWirelessDeviceResponse(messageId.map(value => value))
    def messageId: Option[MessageId]
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceResponse
  ) extends zio.aws.iotwireless.model.SendDataToWirelessDeviceResponse.ReadOnly {
    override val messageId: Option[MessageId] = scala
      .Option(impl.messageId())
      .map(value => zio.aws.iotwireless.model.primitives.MessageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceResponse
  ): zio.aws.iotwireless.model.SendDataToWirelessDeviceResponse.ReadOnly =
    new Wrapper(impl)
}
