package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{
  PayloadData,
  TransmitMode,
  WirelessDeviceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SendDataToWirelessDeviceRequest(
    id: WirelessDeviceId,
    transmitMode: TransmitMode,
    payloadData: PayloadData,
    wirelessMetadata: Option[zio.aws.iotwireless.model.WirelessMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceRequest = {
    import SendDataToWirelessDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceRequest
      .builder()
      .id(WirelessDeviceId.unwrap(id): java.lang.String)
      .transmitMode(TransmitMode.unwrap(transmitMode): Integer)
      .payloadData(PayloadData.unwrap(payloadData): java.lang.String)
      .optionallyWith(wirelessMetadata.map(value => value.buildAwsValue()))(
        _.wirelessMetadata
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.SendDataToWirelessDeviceRequest.ReadOnly =
    zio.aws.iotwireless.model.SendDataToWirelessDeviceRequest
      .wrap(buildAwsValue())
}
object SendDataToWirelessDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SendDataToWirelessDeviceRequest =
      zio.aws.iotwireless.model.SendDataToWirelessDeviceRequest(
        id,
        transmitMode,
        payloadData,
        wirelessMetadata.map(value => value.asEditable)
      )
    def id: WirelessDeviceId
    def transmitMode: TransmitMode
    def payloadData: PayloadData
    def wirelessMetadata
        : Option[zio.aws.iotwireless.model.WirelessMetadata.ReadOnly]
    def getId: ZIO[Any, Nothing, WirelessDeviceId] = ZIO.succeed(id)
    def getTransmitMode: ZIO[Any, Nothing, TransmitMode] =
      ZIO.succeed(transmitMode)
    def getPayloadData: ZIO[Any, Nothing, PayloadData] =
      ZIO.succeed(payloadData)
    def getWirelessMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("wirelessMetadata", wirelessMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceRequest
  ) extends zio.aws.iotwireless.model.SendDataToWirelessDeviceRequest.ReadOnly {
    override val id: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives.WirelessDeviceId(impl.id())
    override val transmitMode: TransmitMode =
      zio.aws.iotwireless.model.primitives.TransmitMode(impl.transmitMode())
    override val payloadData: PayloadData =
      zio.aws.iotwireless.model.primitives.PayloadData(impl.payloadData())
    override val wirelessMetadata
        : Option[zio.aws.iotwireless.model.WirelessMetadata.ReadOnly] = scala
      .Option(impl.wirelessMetadata())
      .map(value => zio.aws.iotwireless.model.WirelessMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SendDataToWirelessDeviceRequest
  ): zio.aws.iotwireless.model.SendDataToWirelessDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
