package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProximityEventConfiguration(
    sidewalk: Option[
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ProximityEventConfiguration = {
    import ProximityEventConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ProximityEventConfiguration
      .builder()
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ProximityEventConfiguration.ReadOnly =
    zio.aws.iotwireless.model.ProximityEventConfiguration.wrap(buildAwsValue())
}
object ProximityEventConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ProximityEventConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ProximityEventConfiguration =
      zio.aws.iotwireless.model
        .ProximityEventConfiguration(sidewalk.map(value => value.asEditable))
    def sidewalk: Option[
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations.ReadOnly
    ]
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ProximityEventConfiguration
  ) extends zio.aws.iotwireless.model.ProximityEventConfiguration.ReadOnly {
    override val sidewalk: Option[
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations.ReadOnly
    ] = scala
      .Option(impl.sidewalk())
      .map(value =>
        zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ProximityEventConfiguration
  ): zio.aws.iotwireless.model.ProximityEventConfiguration.ReadOnly =
    new Wrapper(impl)
}
