package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MulticastWirelessMetadata(
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANMulticastMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.MulticastWirelessMetadata = {
    import MulticastWirelessMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.MulticastWirelessMetadata
      .builder()
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.MulticastWirelessMetadata.ReadOnly =
    zio.aws.iotwireless.model.MulticastWirelessMetadata.wrap(buildAwsValue())
}
object MulticastWirelessMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.MulticastWirelessMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.MulticastWirelessMetadata =
      zio.aws.iotwireless.model
        .MulticastWirelessMetadata(loRaWAN.map(value => value.asEditable))
    def loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANMulticastMetadata.ReadOnly]
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANMulticastMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.MulticastWirelessMetadata
  ) extends zio.aws.iotwireless.model.MulticastWirelessMetadata.ReadOnly {
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANMulticastMetadata.ReadOnly] =
      scala
        .Option(impl.loRaWAN())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANMulticastMetadata.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.MulticastWirelessMetadata
  ): zio.aws.iotwireless.model.MulticastWirelessMetadata.ReadOnly = new Wrapper(
    impl
  )
}
