package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  MulticastGroupName,
  MulticastGroupArn,
  MulticastGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MulticastGroup(
    id: Option[MulticastGroupId] = None,
    arn: Option[MulticastGroupArn] = None,
    name: Option[MulticastGroupName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.MulticastGroup = {
    import MulticastGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.MulticastGroup
      .builder()
      .optionallyWith(
        id.map(value => MulticastGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => MulticastGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => MulticastGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.MulticastGroup.ReadOnly =
    zio.aws.iotwireless.model.MulticastGroup.wrap(buildAwsValue())
}
object MulticastGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.MulticastGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.MulticastGroup =
      zio.aws.iotwireless.model.MulticastGroup(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value)
      )
    def id: Option[MulticastGroupId]
    def arn: Option[MulticastGroupArn]
    def name: Option[MulticastGroupName]
    def getId: ZIO[Any, AwsError, MulticastGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, MulticastGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, MulticastGroupName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.MulticastGroup
  ) extends zio.aws.iotwireless.model.MulticastGroup.ReadOnly {
    override val id: Option[MulticastGroupId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupId(value)
      )
    override val arn: Option[MulticastGroupArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupArn(value)
      )
    override val name: Option[MulticastGroupName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.MulticastGroup
  ): zio.aws.iotwireless.model.MulticastGroup.ReadOnly = new Wrapper(impl)
}
