package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{ServiceProfileId, DeviceProfileId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANUpdateDevice(
    deviceProfileId: Option[DeviceProfileId] = None,
    serviceProfileId: Option[ServiceProfileId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateDevice = {
    import LoRaWANUpdateDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateDevice
      .builder()
      .optionallyWith(
        deviceProfileId.map(value =>
          DeviceProfileId.unwrap(value): java.lang.String
        )
      )(_.deviceProfileId)
      .optionallyWith(
        serviceProfileId.map(value =>
          ServiceProfileId.unwrap(value): java.lang.String
        )
      )(_.serviceProfileId)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANUpdateDevice.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANUpdateDevice.wrap(buildAwsValue())
}
object LoRaWANUpdateDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANUpdateDevice =
      zio.aws.iotwireless.model.LoRaWANUpdateDevice(
        deviceProfileId.map(value => value),
        serviceProfileId.map(value => value)
      )
    def deviceProfileId: Option[DeviceProfileId]
    def serviceProfileId: Option[ServiceProfileId]
    def getDeviceProfileId: ZIO[Any, AwsError, DeviceProfileId] =
      AwsError.unwrapOptionField("deviceProfileId", deviceProfileId)
    def getServiceProfileId: ZIO[Any, AwsError, ServiceProfileId] =
      AwsError.unwrapOptionField("serviceProfileId", serviceProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateDevice
  ) extends zio.aws.iotwireless.model.LoRaWANUpdateDevice.ReadOnly {
    override val deviceProfileId: Option[DeviceProfileId] = scala
      .Option(impl.deviceProfileId())
      .map(value => zio.aws.iotwireless.model.primitives.DeviceProfileId(value))
    override val serviceProfileId: Option[ServiceProfileId] = scala
      .Option(impl.serviceProfileId())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ServiceProfileId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateDevice
  ): zio.aws.iotwireless.model.LoRaWANUpdateDevice.ReadOnly = new Wrapper(impl)
}
