package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANMulticast(
    rfRegion: Option[zio.aws.iotwireless.model.SupportedRfRegion] = None,
    dlClass: Option[zio.aws.iotwireless.model.DlClass] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticast = {
    import LoRaWANMulticast.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticast
      .builder()
      .optionallyWith(rfRegion.map(value => value.unwrap))(_.rfRegion)
      .optionallyWith(dlClass.map(value => value.unwrap))(_.dlClass)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANMulticast.wrap(buildAwsValue())
}
object LoRaWANMulticast {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticast
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANMulticast =
      zio.aws.iotwireless.model.LoRaWANMulticast(
        rfRegion.map(value => value),
        dlClass.map(value => value)
      )
    def rfRegion: Option[zio.aws.iotwireless.model.SupportedRfRegion]
    def dlClass: Option[zio.aws.iotwireless.model.DlClass]
    def getRfRegion
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.SupportedRfRegion] =
      AwsError.unwrapOptionField("rfRegion", rfRegion)
    def getDlClass: ZIO[Any, AwsError, zio.aws.iotwireless.model.DlClass] =
      AwsError.unwrapOptionField("dlClass", dlClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticast
  ) extends zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly {
    override val rfRegion: Option[zio.aws.iotwireless.model.SupportedRfRegion] =
      scala
        .Option(impl.rfRegion())
        .map(value => zio.aws.iotwireless.model.SupportedRfRegion.wrap(value))
    override val dlClass: Option[zio.aws.iotwireless.model.DlClass] = scala
      .Option(impl.dlClass())
      .map(value => zio.aws.iotwireless.model.DlClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticast
  ): zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly = new Wrapper(impl)
}
