package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{
  DlRatePolicy,
  ReportDevStatusBattery,
  ReportDevStatusMargin,
  UlRate,
  DrMin,
  UlBucketSize,
  DevStatusReqFreq,
  HrAllowed,
  AddGwMetadata,
  DrMax,
  RaAllowed,
  UlRatePolicy,
  PrAllowed,
  NwkGeoLoc,
  TargetPer,
  DlBucketSize,
  DlRate,
  ChannelMask,
  MinGwDiversity
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANGetServiceProfileInfo(
    ulRate: Option[UlRate] = None,
    ulBucketSize: Option[UlBucketSize] = None,
    ulRatePolicy: Option[UlRatePolicy] = None,
    dlRate: Option[DlRate] = None,
    dlBucketSize: Option[DlBucketSize] = None,
    dlRatePolicy: Option[DlRatePolicy] = None,
    addGwMetadata: Option[AddGwMetadata] = None,
    devStatusReqFreq: Option[DevStatusReqFreq] = None,
    reportDevStatusBattery: Option[ReportDevStatusBattery] = None,
    reportDevStatusMargin: Option[ReportDevStatusMargin] = None,
    drMin: Option[DrMin] = None,
    drMax: Option[DrMax] = None,
    channelMask: Option[ChannelMask] = None,
    prAllowed: Option[PrAllowed] = None,
    hrAllowed: Option[HrAllowed] = None,
    raAllowed: Option[RaAllowed] = None,
    nwkGeoLoc: Option[NwkGeoLoc] = None,
    targetPer: Option[TargetPer] = None,
    minGwDiversity: Option[MinGwDiversity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANGetServiceProfileInfo = {
    import LoRaWANGetServiceProfileInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGetServiceProfileInfo
      .builder()
      .optionallyWith(ulRate.map(value => UlRate.unwrap(value): Integer))(
        _.ulRate
      )
      .optionallyWith(
        ulBucketSize.map(value => UlBucketSize.unwrap(value): Integer)
      )(_.ulBucketSize)
      .optionallyWith(
        ulRatePolicy.map(value => UlRatePolicy.unwrap(value): java.lang.String)
      )(_.ulRatePolicy)
      .optionallyWith(dlRate.map(value => DlRate.unwrap(value): Integer))(
        _.dlRate
      )
      .optionallyWith(
        dlBucketSize.map(value => DlBucketSize.unwrap(value): Integer)
      )(_.dlBucketSize)
      .optionallyWith(
        dlRatePolicy.map(value => DlRatePolicy.unwrap(value): java.lang.String)
      )(_.dlRatePolicy)
      .optionallyWith(
        addGwMetadata.map(value =>
          AddGwMetadata.unwrap(value): java.lang.Boolean
        )
      )(_.addGwMetadata)
      .optionallyWith(
        devStatusReqFreq.map(value => DevStatusReqFreq.unwrap(value): Integer)
      )(_.devStatusReqFreq)
      .optionallyWith(
        reportDevStatusBattery.map(value =>
          ReportDevStatusBattery.unwrap(value): java.lang.Boolean
        )
      )(_.reportDevStatusBattery)
      .optionallyWith(
        reportDevStatusMargin.map(value =>
          ReportDevStatusMargin.unwrap(value): java.lang.Boolean
        )
      )(_.reportDevStatusMargin)
      .optionallyWith(drMin.map(value => DrMin.unwrap(value): Integer))(_.drMin)
      .optionallyWith(drMax.map(value => DrMax.unwrap(value): Integer))(_.drMax)
      .optionallyWith(
        channelMask.map(value => ChannelMask.unwrap(value): java.lang.String)
      )(_.channelMask)
      .optionallyWith(
        prAllowed.map(value => PrAllowed.unwrap(value): java.lang.Boolean)
      )(_.prAllowed)
      .optionallyWith(
        hrAllowed.map(value => HrAllowed.unwrap(value): java.lang.Boolean)
      )(_.hrAllowed)
      .optionallyWith(
        raAllowed.map(value => RaAllowed.unwrap(value): java.lang.Boolean)
      )(_.raAllowed)
      .optionallyWith(
        nwkGeoLoc.map(value => NwkGeoLoc.unwrap(value): java.lang.Boolean)
      )(_.nwkGeoLoc)
      .optionallyWith(targetPer.map(value => TargetPer.unwrap(value): Integer))(
        _.targetPer
      )
      .optionallyWith(
        minGwDiversity.map(value => MinGwDiversity.unwrap(value): Integer)
      )(_.minGwDiversity)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo.wrap(buildAwsValue())
}
object LoRaWANGetServiceProfileInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGetServiceProfileInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo =
      zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo(
        ulRate.map(value => value),
        ulBucketSize.map(value => value),
        ulRatePolicy.map(value => value),
        dlRate.map(value => value),
        dlBucketSize.map(value => value),
        dlRatePolicy.map(value => value),
        addGwMetadata.map(value => value),
        devStatusReqFreq.map(value => value),
        reportDevStatusBattery.map(value => value),
        reportDevStatusMargin.map(value => value),
        drMin.map(value => value),
        drMax.map(value => value),
        channelMask.map(value => value),
        prAllowed.map(value => value),
        hrAllowed.map(value => value),
        raAllowed.map(value => value),
        nwkGeoLoc.map(value => value),
        targetPer.map(value => value),
        minGwDiversity.map(value => value)
      )
    def ulRate: Option[UlRate]
    def ulBucketSize: Option[UlBucketSize]
    def ulRatePolicy: Option[UlRatePolicy]
    def dlRate: Option[DlRate]
    def dlBucketSize: Option[DlBucketSize]
    def dlRatePolicy: Option[DlRatePolicy]
    def addGwMetadata: Option[AddGwMetadata]
    def devStatusReqFreq: Option[DevStatusReqFreq]
    def reportDevStatusBattery: Option[ReportDevStatusBattery]
    def reportDevStatusMargin: Option[ReportDevStatusMargin]
    def drMin: Option[DrMin]
    def drMax: Option[DrMax]
    def channelMask: Option[ChannelMask]
    def prAllowed: Option[PrAllowed]
    def hrAllowed: Option[HrAllowed]
    def raAllowed: Option[RaAllowed]
    def nwkGeoLoc: Option[NwkGeoLoc]
    def targetPer: Option[TargetPer]
    def minGwDiversity: Option[MinGwDiversity]
    def getUlRate: ZIO[Any, AwsError, UlRate] =
      AwsError.unwrapOptionField("ulRate", ulRate)
    def getUlBucketSize: ZIO[Any, AwsError, UlBucketSize] =
      AwsError.unwrapOptionField("ulBucketSize", ulBucketSize)
    def getUlRatePolicy: ZIO[Any, AwsError, UlRatePolicy] =
      AwsError.unwrapOptionField("ulRatePolicy", ulRatePolicy)
    def getDlRate: ZIO[Any, AwsError, DlRate] =
      AwsError.unwrapOptionField("dlRate", dlRate)
    def getDlBucketSize: ZIO[Any, AwsError, DlBucketSize] =
      AwsError.unwrapOptionField("dlBucketSize", dlBucketSize)
    def getDlRatePolicy: ZIO[Any, AwsError, DlRatePolicy] =
      AwsError.unwrapOptionField("dlRatePolicy", dlRatePolicy)
    def getAddGwMetadata: ZIO[Any, AwsError, AddGwMetadata] =
      AwsError.unwrapOptionField("addGwMetadata", addGwMetadata)
    def getDevStatusReqFreq: ZIO[Any, AwsError, DevStatusReqFreq] =
      AwsError.unwrapOptionField("devStatusReqFreq", devStatusReqFreq)
    def getReportDevStatusBattery: ZIO[Any, AwsError, ReportDevStatusBattery] =
      AwsError.unwrapOptionField(
        "reportDevStatusBattery",
        reportDevStatusBattery
      )
    def getReportDevStatusMargin: ZIO[Any, AwsError, ReportDevStatusMargin] =
      AwsError.unwrapOptionField("reportDevStatusMargin", reportDevStatusMargin)
    def getDrMin: ZIO[Any, AwsError, DrMin] =
      AwsError.unwrapOptionField("drMin", drMin)
    def getDrMax: ZIO[Any, AwsError, DrMax] =
      AwsError.unwrapOptionField("drMax", drMax)
    def getChannelMask: ZIO[Any, AwsError, ChannelMask] =
      AwsError.unwrapOptionField("channelMask", channelMask)
    def getPrAllowed: ZIO[Any, AwsError, PrAllowed] =
      AwsError.unwrapOptionField("prAllowed", prAllowed)
    def getHrAllowed: ZIO[Any, AwsError, HrAllowed] =
      AwsError.unwrapOptionField("hrAllowed", hrAllowed)
    def getRaAllowed: ZIO[Any, AwsError, RaAllowed] =
      AwsError.unwrapOptionField("raAllowed", raAllowed)
    def getNwkGeoLoc: ZIO[Any, AwsError, NwkGeoLoc] =
      AwsError.unwrapOptionField("nwkGeoLoc", nwkGeoLoc)
    def getTargetPer: ZIO[Any, AwsError, TargetPer] =
      AwsError.unwrapOptionField("targetPer", targetPer)
    def getMinGwDiversity: ZIO[Any, AwsError, MinGwDiversity] =
      AwsError.unwrapOptionField("minGwDiversity", minGwDiversity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGetServiceProfileInfo
  ) extends zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo.ReadOnly {
    override val ulRate: Option[UlRate] = scala
      .Option(impl.ulRate())
      .map(value => zio.aws.iotwireless.model.primitives.UlRate(value))
    override val ulBucketSize: Option[UlBucketSize] = scala
      .Option(impl.ulBucketSize())
      .map(value => zio.aws.iotwireless.model.primitives.UlBucketSize(value))
    override val ulRatePolicy: Option[UlRatePolicy] = scala
      .Option(impl.ulRatePolicy())
      .map(value => zio.aws.iotwireless.model.primitives.UlRatePolicy(value))
    override val dlRate: Option[DlRate] = scala
      .Option(impl.dlRate())
      .map(value => zio.aws.iotwireless.model.primitives.DlRate(value))
    override val dlBucketSize: Option[DlBucketSize] = scala
      .Option(impl.dlBucketSize())
      .map(value => zio.aws.iotwireless.model.primitives.DlBucketSize(value))
    override val dlRatePolicy: Option[DlRatePolicy] = scala
      .Option(impl.dlRatePolicy())
      .map(value => zio.aws.iotwireless.model.primitives.DlRatePolicy(value))
    override val addGwMetadata: Option[AddGwMetadata] = scala
      .Option(impl.addGwMetadata())
      .map(value => zio.aws.iotwireless.model.primitives.AddGwMetadata(value))
    override val devStatusReqFreq: Option[DevStatusReqFreq] = scala
      .Option(impl.devStatusReqFreq())
      .map(value =>
        zio.aws.iotwireless.model.primitives.DevStatusReqFreq(value)
      )
    override val reportDevStatusBattery: Option[ReportDevStatusBattery] = scala
      .Option(impl.reportDevStatusBattery())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ReportDevStatusBattery(value)
      )
    override val reportDevStatusMargin: Option[ReportDevStatusMargin] = scala
      .Option(impl.reportDevStatusMargin())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ReportDevStatusMargin(value)
      )
    override val drMin: Option[DrMin] = scala
      .Option(impl.drMin())
      .map(value => zio.aws.iotwireless.model.primitives.DrMin(value))
    override val drMax: Option[DrMax] = scala
      .Option(impl.drMax())
      .map(value => zio.aws.iotwireless.model.primitives.DrMax(value))
    override val channelMask: Option[ChannelMask] = scala
      .Option(impl.channelMask())
      .map(value => zio.aws.iotwireless.model.primitives.ChannelMask(value))
    override val prAllowed: Option[PrAllowed] = scala
      .Option(impl.prAllowed())
      .map(value => zio.aws.iotwireless.model.primitives.PrAllowed(value))
    override val hrAllowed: Option[HrAllowed] = scala
      .Option(impl.hrAllowed())
      .map(value => zio.aws.iotwireless.model.primitives.HrAllowed(value))
    override val raAllowed: Option[RaAllowed] = scala
      .Option(impl.raAllowed())
      .map(value => zio.aws.iotwireless.model.primitives.RaAllowed(value))
    override val nwkGeoLoc: Option[NwkGeoLoc] = scala
      .Option(impl.nwkGeoLoc())
      .map(value => zio.aws.iotwireless.model.primitives.NwkGeoLoc(value))
    override val targetPer: Option[TargetPer] = scala
      .Option(impl.targetPer())
      .map(value => zio.aws.iotwireless.model.primitives.TargetPer(value))
    override val minGwDiversity: Option[MinGwDiversity] = scala
      .Option(impl.minGwDiversity())
      .map(value => zio.aws.iotwireless.model.primitives.MinGwDiversity(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGetServiceProfileInfo
  ): zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo.ReadOnly =
    new Wrapper(impl)
}
