package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{Station, Model, PackageVersion}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANGatewayVersion(
    packageVersion: Option[PackageVersion] = None,
    model: Option[Model] = None,
    station: Option[Station] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayVersion = {
    import LoRaWANGatewayVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayVersion
      .builder()
      .optionallyWith(
        packageVersion.map(value =>
          PackageVersion.unwrap(value): java.lang.String
        )
      )(_.packageVersion)
      .optionallyWith(
        model.map(value => Model.unwrap(value): java.lang.String)
      )(_.model)
      .optionallyWith(
        station.map(value => Station.unwrap(value): java.lang.String)
      )(_.station)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANGatewayVersion.wrap(buildAwsValue())
}
object LoRaWANGatewayVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANGatewayVersion =
      zio.aws.iotwireless.model.LoRaWANGatewayVersion(
        packageVersion.map(value => value),
        model.map(value => value),
        station.map(value => value)
      )
    def packageVersion: Option[PackageVersion]
    def model: Option[Model]
    def station: Option[Station]
    def getPackageVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("packageVersion", packageVersion)
    def getModel: ZIO[Any, AwsError, Model] =
      AwsError.unwrapOptionField("model", model)
    def getStation: ZIO[Any, AwsError, Station] =
      AwsError.unwrapOptionField("station", station)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayVersion
  ) extends zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly {
    override val packageVersion: Option[PackageVersion] = scala
      .Option(impl.packageVersion())
      .map(value => zio.aws.iotwireless.model.primitives.PackageVersion(value))
    override val model: Option[Model] = scala
      .Option(impl.model())
      .map(value => zio.aws.iotwireless.model.primitives.Model(value))
    override val station: Option[Station] = scala
      .Option(impl.station())
      .map(value => zio.aws.iotwireless.model.primitives.Station(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayVersion
  ): zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly = new Wrapper(
    impl
  )
}
