package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{
  Supports32BitFCnt,
  RxFreq2,
  RxDataRate2,
  RegParamsRevision,
  PingSlotFreq,
  SupportsClassC,
  PingSlotDr,
  PingSlotPeriod,
  MacVersion,
  PresetFreq,
  ClassCTimeout,
  MaxEirp,
  RxDelay1,
  ClassBTimeout,
  RxDrOffset1,
  MaxDutyCycle,
  SupportsJoin,
  RfRegion,
  SupportsClassB
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANDeviceProfile(
    supportsClassB: Option[SupportsClassB] = None,
    classBTimeout: Option[ClassBTimeout] = None,
    pingSlotPeriod: Option[PingSlotPeriod] = None,
    pingSlotDr: Option[PingSlotDr] = None,
    pingSlotFreq: Option[PingSlotFreq] = None,
    supportsClassC: Option[SupportsClassC] = None,
    classCTimeout: Option[ClassCTimeout] = None,
    macVersion: Option[MacVersion] = None,
    regParamsRevision: Option[RegParamsRevision] = None,
    rxDelay1: Option[RxDelay1] = None,
    rxDrOffset1: Option[RxDrOffset1] = None,
    rxDataRate2: Option[RxDataRate2] = None,
    rxFreq2: Option[RxFreq2] = None,
    factoryPresetFreqsList: Option[Iterable[PresetFreq]] = None,
    maxEirp: Option[MaxEirp] = None,
    maxDutyCycle: Option[MaxDutyCycle] = None,
    rfRegion: Option[RfRegion] = None,
    supportsJoin: Option[SupportsJoin] = None,
    supports32BitFCnt: Option[Supports32BitFCnt] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceProfile = {
    import LoRaWANDeviceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceProfile
      .builder()
      .optionallyWith(
        supportsClassB.map(value =>
          SupportsClassB.unwrap(value): java.lang.Boolean
        )
      )(_.supportsClassB)
      .optionallyWith(
        classBTimeout.map(value => ClassBTimeout.unwrap(value): Integer)
      )(_.classBTimeout)
      .optionallyWith(
        pingSlotPeriod.map(value => PingSlotPeriod.unwrap(value): Integer)
      )(_.pingSlotPeriod)
      .optionallyWith(
        pingSlotDr.map(value => PingSlotDr.unwrap(value): Integer)
      )(_.pingSlotDr)
      .optionallyWith(
        pingSlotFreq.map(value => PingSlotFreq.unwrap(value): Integer)
      )(_.pingSlotFreq)
      .optionallyWith(
        supportsClassC.map(value =>
          SupportsClassC.unwrap(value): java.lang.Boolean
        )
      )(_.supportsClassC)
      .optionallyWith(
        classCTimeout.map(value => ClassCTimeout.unwrap(value): Integer)
      )(_.classCTimeout)
      .optionallyWith(
        macVersion.map(value => MacVersion.unwrap(value): java.lang.String)
      )(_.macVersion)
      .optionallyWith(
        regParamsRevision.map(value =>
          RegParamsRevision.unwrap(value): java.lang.String
        )
      )(_.regParamsRevision)
      .optionallyWith(rxDelay1.map(value => RxDelay1.unwrap(value): Integer))(
        _.rxDelay1
      )
      .optionallyWith(
        rxDrOffset1.map(value => RxDrOffset1.unwrap(value): Integer)
      )(_.rxDrOffset1)
      .optionallyWith(
        rxDataRate2.map(value => RxDataRate2.unwrap(value): Integer)
      )(_.rxDataRate2)
      .optionallyWith(rxFreq2.map(value => RxFreq2.unwrap(value): Integer))(
        _.rxFreq2
      )
      .optionallyWith(
        factoryPresetFreqsList.map(value =>
          value.map { item =>
            PresetFreq.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.factoryPresetFreqsList)
      .optionallyWith(maxEirp.map(value => MaxEirp.unwrap(value): Integer))(
        _.maxEirp
      )
      .optionallyWith(
        maxDutyCycle.map(value => MaxDutyCycle.unwrap(value): Integer)
      )(_.maxDutyCycle)
      .optionallyWith(
        rfRegion.map(value => RfRegion.unwrap(value): java.lang.String)
      )(_.rfRegion)
      .optionallyWith(
        supportsJoin.map(value => SupportsJoin.unwrap(value): java.lang.Boolean)
      )(_.supportsJoin)
      .optionallyWith(
        supports32BitFCnt.map(value =>
          Supports32BitFCnt.unwrap(value): java.lang.Boolean
        )
      )(_.supports32BitFCnt)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANDeviceProfile.wrap(buildAwsValue())
}
object LoRaWANDeviceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANDeviceProfile =
      zio.aws.iotwireless.model.LoRaWANDeviceProfile(
        supportsClassB.map(value => value),
        classBTimeout.map(value => value),
        pingSlotPeriod.map(value => value),
        pingSlotDr.map(value => value),
        pingSlotFreq.map(value => value),
        supportsClassC.map(value => value),
        classCTimeout.map(value => value),
        macVersion.map(value => value),
        regParamsRevision.map(value => value),
        rxDelay1.map(value => value),
        rxDrOffset1.map(value => value),
        rxDataRate2.map(value => value),
        rxFreq2.map(value => value),
        factoryPresetFreqsList.map(value => value),
        maxEirp.map(value => value),
        maxDutyCycle.map(value => value),
        rfRegion.map(value => value),
        supportsJoin.map(value => value),
        supports32BitFCnt.map(value => value)
      )
    def supportsClassB: Option[SupportsClassB]
    def classBTimeout: Option[ClassBTimeout]
    def pingSlotPeriod: Option[PingSlotPeriod]
    def pingSlotDr: Option[PingSlotDr]
    def pingSlotFreq: Option[PingSlotFreq]
    def supportsClassC: Option[SupportsClassC]
    def classCTimeout: Option[ClassCTimeout]
    def macVersion: Option[MacVersion]
    def regParamsRevision: Option[RegParamsRevision]
    def rxDelay1: Option[RxDelay1]
    def rxDrOffset1: Option[RxDrOffset1]
    def rxDataRate2: Option[RxDataRate2]
    def rxFreq2: Option[RxFreq2]
    def factoryPresetFreqsList: Option[List[PresetFreq]]
    def maxEirp: Option[MaxEirp]
    def maxDutyCycle: Option[MaxDutyCycle]
    def rfRegion: Option[RfRegion]
    def supportsJoin: Option[SupportsJoin]
    def supports32BitFCnt: Option[Supports32BitFCnt]
    def getSupportsClassB: ZIO[Any, AwsError, SupportsClassB] =
      AwsError.unwrapOptionField("supportsClassB", supportsClassB)
    def getClassBTimeout: ZIO[Any, AwsError, ClassBTimeout] =
      AwsError.unwrapOptionField("classBTimeout", classBTimeout)
    def getPingSlotPeriod: ZIO[Any, AwsError, PingSlotPeriod] =
      AwsError.unwrapOptionField("pingSlotPeriod", pingSlotPeriod)
    def getPingSlotDr: ZIO[Any, AwsError, PingSlotDr] =
      AwsError.unwrapOptionField("pingSlotDr", pingSlotDr)
    def getPingSlotFreq: ZIO[Any, AwsError, PingSlotFreq] =
      AwsError.unwrapOptionField("pingSlotFreq", pingSlotFreq)
    def getSupportsClassC: ZIO[Any, AwsError, SupportsClassC] =
      AwsError.unwrapOptionField("supportsClassC", supportsClassC)
    def getClassCTimeout: ZIO[Any, AwsError, ClassCTimeout] =
      AwsError.unwrapOptionField("classCTimeout", classCTimeout)
    def getMacVersion: ZIO[Any, AwsError, MacVersion] =
      AwsError.unwrapOptionField("macVersion", macVersion)
    def getRegParamsRevision: ZIO[Any, AwsError, RegParamsRevision] =
      AwsError.unwrapOptionField("regParamsRevision", regParamsRevision)
    def getRxDelay1: ZIO[Any, AwsError, RxDelay1] =
      AwsError.unwrapOptionField("rxDelay1", rxDelay1)
    def getRxDrOffset1: ZIO[Any, AwsError, RxDrOffset1] =
      AwsError.unwrapOptionField("rxDrOffset1", rxDrOffset1)
    def getRxDataRate2: ZIO[Any, AwsError, RxDataRate2] =
      AwsError.unwrapOptionField("rxDataRate2", rxDataRate2)
    def getRxFreq2: ZIO[Any, AwsError, RxFreq2] =
      AwsError.unwrapOptionField("rxFreq2", rxFreq2)
    def getFactoryPresetFreqsList: ZIO[Any, AwsError, List[PresetFreq]] =
      AwsError.unwrapOptionField(
        "factoryPresetFreqsList",
        factoryPresetFreqsList
      )
    def getMaxEirp: ZIO[Any, AwsError, MaxEirp] =
      AwsError.unwrapOptionField("maxEirp", maxEirp)
    def getMaxDutyCycle: ZIO[Any, AwsError, MaxDutyCycle] =
      AwsError.unwrapOptionField("maxDutyCycle", maxDutyCycle)
    def getRfRegion: ZIO[Any, AwsError, RfRegion] =
      AwsError.unwrapOptionField("rfRegion", rfRegion)
    def getSupportsJoin: ZIO[Any, AwsError, SupportsJoin] =
      AwsError.unwrapOptionField("supportsJoin", supportsJoin)
    def getSupports32BitFCnt: ZIO[Any, AwsError, Supports32BitFCnt] =
      AwsError.unwrapOptionField("supports32BitFCnt", supports32BitFCnt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceProfile
  ) extends zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly {
    override val supportsClassB: Option[SupportsClassB] = scala
      .Option(impl.supportsClassB())
      .map(value => zio.aws.iotwireless.model.primitives.SupportsClassB(value))
    override val classBTimeout: Option[ClassBTimeout] = scala
      .Option(impl.classBTimeout())
      .map(value => zio.aws.iotwireless.model.primitives.ClassBTimeout(value))
    override val pingSlotPeriod: Option[PingSlotPeriod] = scala
      .Option(impl.pingSlotPeriod())
      .map(value => zio.aws.iotwireless.model.primitives.PingSlotPeriod(value))
    override val pingSlotDr: Option[PingSlotDr] = scala
      .Option(impl.pingSlotDr())
      .map(value => zio.aws.iotwireless.model.primitives.PingSlotDr(value))
    override val pingSlotFreq: Option[PingSlotFreq] = scala
      .Option(impl.pingSlotFreq())
      .map(value => zio.aws.iotwireless.model.primitives.PingSlotFreq(value))
    override val supportsClassC: Option[SupportsClassC] = scala
      .Option(impl.supportsClassC())
      .map(value => zio.aws.iotwireless.model.primitives.SupportsClassC(value))
    override val classCTimeout: Option[ClassCTimeout] = scala
      .Option(impl.classCTimeout())
      .map(value => zio.aws.iotwireless.model.primitives.ClassCTimeout(value))
    override val macVersion: Option[MacVersion] = scala
      .Option(impl.macVersion())
      .map(value => zio.aws.iotwireless.model.primitives.MacVersion(value))
    override val regParamsRevision: Option[RegParamsRevision] = scala
      .Option(impl.regParamsRevision())
      .map(value =>
        zio.aws.iotwireless.model.primitives.RegParamsRevision(value)
      )
    override val rxDelay1: Option[RxDelay1] = scala
      .Option(impl.rxDelay1())
      .map(value => zio.aws.iotwireless.model.primitives.RxDelay1(value))
    override val rxDrOffset1: Option[RxDrOffset1] = scala
      .Option(impl.rxDrOffset1())
      .map(value => zio.aws.iotwireless.model.primitives.RxDrOffset1(value))
    override val rxDataRate2: Option[RxDataRate2] = scala
      .Option(impl.rxDataRate2())
      .map(value => zio.aws.iotwireless.model.primitives.RxDataRate2(value))
    override val rxFreq2: Option[RxFreq2] = scala
      .Option(impl.rxFreq2())
      .map(value => zio.aws.iotwireless.model.primitives.RxFreq2(value))
    override val factoryPresetFreqsList: Option[List[PresetFreq]] = scala
      .Option(impl.factoryPresetFreqsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.primitives.PresetFreq(item)
        }.toList
      )
    override val maxEirp: Option[MaxEirp] = scala
      .Option(impl.maxEirp())
      .map(value => zio.aws.iotwireless.model.primitives.MaxEirp(value))
    override val maxDutyCycle: Option[MaxDutyCycle] = scala
      .Option(impl.maxDutyCycle())
      .map(value => zio.aws.iotwireless.model.primitives.MaxDutyCycle(value))
    override val rfRegion: Option[RfRegion] = scala
      .Option(impl.rfRegion())
      .map(value => zio.aws.iotwireless.model.primitives.RfRegion(value))
    override val supportsJoin: Option[SupportsJoin] = scala
      .Option(impl.supportsJoin())
      .map(value => zio.aws.iotwireless.model.primitives.SupportsJoin(value))
    override val supports32BitFCnt: Option[Supports32BitFCnt] = scala
      .Option(impl.supports32BitFCnt())
      .map(value =>
        zio.aws.iotwireless.model.primitives.Supports32BitFCnt(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceProfile
  ): zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly = new Wrapper(impl)
}
