package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{ISODateTimeString, Integer, DevEui}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANDeviceMetadata(
    devEui: Option[DevEui] = None,
    fPort: Option[Integer] = None,
    dataRate: Option[Integer] = None,
    frequency: Option[Integer] = None,
    timestamp: Option[ISODateTimeString] = None,
    gateways: Option[
      Iterable[zio.aws.iotwireless.model.LoRaWANGatewayMetadata]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceMetadata = {
    import LoRaWANDeviceMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceMetadata
      .builder()
      .optionallyWith(
        devEui.map(value => DevEui.unwrap(value): java.lang.String)
      )(_.devEui)
      .optionallyWith(
        fPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.fPort)
      .optionallyWith(
        dataRate.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.dataRate)
      .optionallyWith(
        frequency.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.frequency)
      .optionallyWith(
        timestamp.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.timestamp)
      .optionallyWith(
        gateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gateways)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANDeviceMetadata.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANDeviceMetadata.wrap(buildAwsValue())
}
object LoRaWANDeviceMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANDeviceMetadata =
      zio.aws.iotwireless.model.LoRaWANDeviceMetadata(
        devEui.map(value => value),
        fPort.map(value => value),
        dataRate.map(value => value),
        frequency.map(value => value),
        timestamp.map(value => value),
        gateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def devEui: Option[DevEui]
    def fPort: Option[Integer]
    def dataRate: Option[Integer]
    def frequency: Option[Integer]
    def timestamp: Option[ISODateTimeString]
    def gateways: Option[
      List[zio.aws.iotwireless.model.LoRaWANGatewayMetadata.ReadOnly]
    ]
    def getDevEui: ZIO[Any, AwsError, DevEui] =
      AwsError.unwrapOptionField("devEui", devEui)
    def getFPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fPort", fPort)
    def getDataRate: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dataRate", dataRate)
    def getFrequency: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getTimestamp: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getGateways: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.LoRaWANGatewayMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("gateways", gateways)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceMetadata
  ) extends zio.aws.iotwireless.model.LoRaWANDeviceMetadata.ReadOnly {
    override val devEui: Option[DevEui] = scala
      .Option(impl.devEui())
      .map(value => zio.aws.iotwireless.model.primitives.DevEui(value))
    override val fPort: Option[Integer] = scala
      .Option(impl.fPort())
      .map(value => zio.aws.iotwireless.model.primitives.Integer(value))
    override val dataRate: Option[Integer] = scala
      .Option(impl.dataRate())
      .map(value => zio.aws.iotwireless.model.primitives.Integer(value))
    override val frequency: Option[Integer] = scala
      .Option(impl.frequency())
      .map(value => zio.aws.iotwireless.model.primitives.Integer(value))
    override val timestamp: Option[ISODateTimeString] = scala
      .Option(impl.timestamp())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
      )
    override val gateways: Option[
      List[zio.aws.iotwireless.model.LoRaWANGatewayMetadata.ReadOnly]
    ] = scala
      .Option(impl.gateways())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.LoRaWANGatewayMetadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceMetadata
  ): zio.aws.iotwireless.model.LoRaWANDeviceMetadata.ReadOnly = new Wrapper(
    impl
  )
}
