package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{NextToken, MaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListWirelessGatewayTaskDefinitionsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    taskDefinitionType: Option[
      zio.aws.iotwireless.model.WirelessGatewayTaskDefinitionType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest = {
    import ListWirelessGatewayTaskDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(taskDefinitionType.map(value => value.unwrap))(
        _.taskDefinitionType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest.ReadOnly =
    zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
      .wrap(buildAwsValue())
}
object ListWirelessGatewayTaskDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest =
      zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        taskDefinitionType.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def taskDefinitionType
        : Option[zio.aws.iotwireless.model.WirelessGatewayTaskDefinitionType]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTaskDefinitionType: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessGatewayTaskDefinitionType
    ] = AwsError.unwrapOptionField("taskDefinitionType", taskDefinitionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
  ) extends zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotwireless.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val taskDefinitionType
        : Option[zio.aws.iotwireless.model.WirelessGatewayTaskDefinitionType] =
      scala
        .Option(impl.taskDefinitionType())
        .map(value =>
          zio.aws.iotwireless.model.WirelessGatewayTaskDefinitionType
            .wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
  ): zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
