package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListWirelessDevicesResponse(
    nextToken: Option[NextToken] = None,
    wirelessDeviceList: Option[
      Iterable[zio.aws.iotwireless.model.WirelessDeviceStatistics]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse = {
    import ListWirelessDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        wirelessDeviceList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wirelessDeviceList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListWirelessDevicesResponse.ReadOnly =
    zio.aws.iotwireless.model.ListWirelessDevicesResponse.wrap(buildAwsValue())
}
object ListWirelessDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListWirelessDevicesResponse =
      zio.aws.iotwireless.model.ListWirelessDevicesResponse(
        nextToken.map(value => value),
        wirelessDeviceList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def wirelessDeviceList: Option[
      List[zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWirelessDeviceList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly
    ]] = AwsError.unwrapOptionField("wirelessDeviceList", wirelessDeviceList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse
  ) extends zio.aws.iotwireless.model.ListWirelessDevicesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val wirelessDeviceList: Option[
      List[zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly]
    ] = scala
      .Option(impl.wirelessDeviceList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessDeviceStatistics.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse
  ): zio.aws.iotwireless.model.ListWirelessDevicesResponse.ReadOnly =
    new Wrapper(impl)
}
