package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{
  NextToken,
  MulticastGroupId,
  DeviceProfileId,
  MaxResults,
  FuotaTaskId,
  DestinationName,
  ServiceProfileId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListWirelessDevicesRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    destinationName: Option[DestinationName] = None,
    deviceProfileId: Option[DeviceProfileId] = None,
    serviceProfileId: Option[ServiceProfileId] = None,
    wirelessDeviceType: Option[zio.aws.iotwireless.model.WirelessDeviceType] =
      None,
    fuotaTaskId: Option[FuotaTaskId] = None,
    multicastGroupId: Option[MulticastGroupId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest = {
    import ListWirelessDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        destinationName.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destinationName)
      .optionallyWith(
        deviceProfileId.map(value =>
          DeviceProfileId.unwrap(value): java.lang.String
        )
      )(_.deviceProfileId)
      .optionallyWith(
        serviceProfileId.map(value =>
          ServiceProfileId.unwrap(value): java.lang.String
        )
      )(_.serviceProfileId)
      .optionallyWith(wirelessDeviceType.map(value => value.unwrap))(
        _.wirelessDeviceType
      )
      .optionallyWith(
        fuotaTaskId.map(value => FuotaTaskId.unwrap(value): java.lang.String)
      )(_.fuotaTaskId)
      .optionallyWith(
        multicastGroupId.map(value =>
          MulticastGroupId.unwrap(value): java.lang.String
        )
      )(_.multicastGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListWirelessDevicesRequest.ReadOnly =
    zio.aws.iotwireless.model.ListWirelessDevicesRequest.wrap(buildAwsValue())
}
object ListWirelessDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListWirelessDevicesRequest =
      zio.aws.iotwireless.model.ListWirelessDevicesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        destinationName.map(value => value),
        deviceProfileId.map(value => value),
        serviceProfileId.map(value => value),
        wirelessDeviceType.map(value => value),
        fuotaTaskId.map(value => value),
        multicastGroupId.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def destinationName: Option[DestinationName]
    def deviceProfileId: Option[DeviceProfileId]
    def serviceProfileId: Option[ServiceProfileId]
    def wirelessDeviceType: Option[zio.aws.iotwireless.model.WirelessDeviceType]
    def fuotaTaskId: Option[FuotaTaskId]
    def multicastGroupId: Option[MulticastGroupId]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDestinationName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destinationName", destinationName)
    def getDeviceProfileId: ZIO[Any, AwsError, DeviceProfileId] =
      AwsError.unwrapOptionField("deviceProfileId", deviceProfileId)
    def getServiceProfileId: ZIO[Any, AwsError, ServiceProfileId] =
      AwsError.unwrapOptionField("serviceProfileId", serviceProfileId)
    def getWirelessDeviceType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.WirelessDeviceType] =
      AwsError.unwrapOptionField("wirelessDeviceType", wirelessDeviceType)
    def getFuotaTaskId: ZIO[Any, AwsError, FuotaTaskId] =
      AwsError.unwrapOptionField("fuotaTaskId", fuotaTaskId)
    def getMulticastGroupId: ZIO[Any, AwsError, MulticastGroupId] =
      AwsError.unwrapOptionField("multicastGroupId", multicastGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest
  ) extends zio.aws.iotwireless.model.ListWirelessDevicesRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotwireless.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val destinationName: Option[DestinationName] = scala
      .Option(impl.destinationName())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationName(value))
    override val deviceProfileId: Option[DeviceProfileId] = scala
      .Option(impl.deviceProfileId())
      .map(value => zio.aws.iotwireless.model.primitives.DeviceProfileId(value))
    override val serviceProfileId: Option[ServiceProfileId] = scala
      .Option(impl.serviceProfileId())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ServiceProfileId(value)
      )
    override val wirelessDeviceType
        : Option[zio.aws.iotwireless.model.WirelessDeviceType] = scala
      .Option(impl.wirelessDeviceType())
      .map(value => zio.aws.iotwireless.model.WirelessDeviceType.wrap(value))
    override val fuotaTaskId: Option[FuotaTaskId] = scala
      .Option(impl.fuotaTaskId())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskId(value))
    override val multicastGroupId: Option[MulticastGroupId] = scala
      .Option(impl.multicastGroupId())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest
  ): zio.aws.iotwireless.model.ListWirelessDevicesRequest.ReadOnly =
    new Wrapper(impl)
}
