package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListMulticastGroupsByFuotaTaskResponse(
    nextToken: Option[NextToken] = None,
    multicastGroupList: Option[
      Iterable[zio.aws.iotwireless.model.MulticastGroupByFuotaTask]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse = {
    import ListMulticastGroupsByFuotaTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        multicastGroupList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.multicastGroupList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse.ReadOnly =
    zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse
      .wrap(buildAwsValue())
}
object ListMulticastGroupsByFuotaTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse =
      zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse(
        nextToken.map(value => value),
        multicastGroupList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def multicastGroupList: Option[
      List[zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMulticastGroupList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly
    ]] = AwsError.unwrapOptionField("multicastGroupList", multicastGroupList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse
  ) extends zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val multicastGroupList: Option[
      List[zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly]
    ] = scala
      .Option(impl.multicastGroupList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.MulticastGroupByFuotaTask.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse
  ): zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse.ReadOnly =
    new Wrapper(impl)
}
