package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFuotaTasksResponse(
    nextToken: Option[NextToken] = None,
    fuotaTaskList: Option[Iterable[zio.aws.iotwireless.model.FuotaTask]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse = {
    import ListFuotaTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        fuotaTaskList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fuotaTaskList)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.ListFuotaTasksResponse.ReadOnly =
    zio.aws.iotwireless.model.ListFuotaTasksResponse.wrap(buildAwsValue())
}
object ListFuotaTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListFuotaTasksResponse =
      zio.aws.iotwireless.model.ListFuotaTasksResponse(
        nextToken.map(value => value),
        fuotaTaskList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def fuotaTaskList
        : Option[List[zio.aws.iotwireless.model.FuotaTask.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFuotaTaskList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.FuotaTask.ReadOnly
    ]] = AwsError.unwrapOptionField("fuotaTaskList", fuotaTaskList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse
  ) extends zio.aws.iotwireless.model.ListFuotaTasksResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val fuotaTaskList
        : Option[List[zio.aws.iotwireless.model.FuotaTask.ReadOnly]] = scala
      .Option(impl.fuotaTaskList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.FuotaTask.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse
  ): zio.aws.iotwireless.model.ListFuotaTasksResponse.ReadOnly = new Wrapper(
    impl
  )
}
