package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDeviceProfilesResponse(
    nextToken: Option[NextToken] = None,
    deviceProfileList: Option[
      Iterable[zio.aws.iotwireless.model.DeviceProfile]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse = {
    import ListDeviceProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        deviceProfileList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deviceProfileList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListDeviceProfilesResponse.ReadOnly =
    zio.aws.iotwireless.model.ListDeviceProfilesResponse.wrap(buildAwsValue())
}
object ListDeviceProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListDeviceProfilesResponse =
      zio.aws.iotwireless.model.ListDeviceProfilesResponse(
        nextToken.map(value => value),
        deviceProfileList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def deviceProfileList
        : Option[List[zio.aws.iotwireless.model.DeviceProfile.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDeviceProfileList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.DeviceProfile.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceProfileList", deviceProfileList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse
  ) extends zio.aws.iotwireless.model.ListDeviceProfilesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val deviceProfileList
        : Option[List[zio.aws.iotwireless.model.DeviceProfile.ReadOnly]] = scala
      .Option(impl.deviceProfileList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.DeviceProfile.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse
  ): zio.aws.iotwireless.model.ListDeviceProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
