package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{NextToken, MaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDestinationsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest = {
    import ListDestinationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.ListDestinationsRequest.ReadOnly =
    zio.aws.iotwireless.model.ListDestinationsRequest.wrap(buildAwsValue())
}
object ListDestinationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListDestinationsRequest =
      zio.aws.iotwireless.model.ListDestinationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest
  ) extends zio.aws.iotwireless.model.ListDestinationsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotwireless.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest
  ): zio.aws.iotwireless.model.ListDestinationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
