package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ISODateTimeString,
  WirelessGatewayTaskDefinitionId,
  WirelessGatewayId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayTaskResponse(
    wirelessGatewayId: Option[WirelessGatewayId] = None,
    wirelessGatewayTaskDefinitionId: Option[WirelessGatewayTaskDefinitionId] =
      None,
    lastUplinkReceivedAt: Option[ISODateTimeString] = None,
    taskCreatedAt: Option[ISODateTimeString] = None,
    status: Option[zio.aws.iotwireless.model.WirelessGatewayTaskStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse = {
    import GetWirelessGatewayTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse
      .builder()
      .optionallyWith(
        wirelessGatewayId.map(value =>
          WirelessGatewayId.unwrap(value): java.lang.String
        )
      )(_.wirelessGatewayId)
      .optionallyWith(
        wirelessGatewayTaskDefinitionId.map(value =>
          WirelessGatewayTaskDefinitionId.unwrap(value): java.lang.String
        )
      )(_.wirelessGatewayTaskDefinitionId)
      .optionallyWith(
        lastUplinkReceivedAt.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.lastUplinkReceivedAt)
      .optionallyWith(
        taskCreatedAt.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.taskCreatedAt)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse
      .wrap(buildAwsValue())
}
object GetWirelessGatewayTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse =
      zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse(
        wirelessGatewayId.map(value => value),
        wirelessGatewayTaskDefinitionId.map(value => value),
        lastUplinkReceivedAt.map(value => value),
        taskCreatedAt.map(value => value),
        status.map(value => value)
      )
    def wirelessGatewayId: Option[WirelessGatewayId]
    def wirelessGatewayTaskDefinitionId: Option[WirelessGatewayTaskDefinitionId]
    def lastUplinkReceivedAt: Option[ISODateTimeString]
    def taskCreatedAt: Option[ISODateTimeString]
    def status: Option[zio.aws.iotwireless.model.WirelessGatewayTaskStatus]
    def getWirelessGatewayId: ZIO[Any, AwsError, WirelessGatewayId] =
      AwsError.unwrapOptionField("wirelessGatewayId", wirelessGatewayId)
    def getWirelessGatewayTaskDefinitionId
        : ZIO[Any, AwsError, WirelessGatewayTaskDefinitionId] =
      AwsError.unwrapOptionField(
        "wirelessGatewayTaskDefinitionId",
        wirelessGatewayTaskDefinitionId
      )
    def getLastUplinkReceivedAt: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("lastUplinkReceivedAt", lastUplinkReceivedAt)
    def getTaskCreatedAt: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("taskCreatedAt", taskCreatedAt)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessGatewayTaskStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse.ReadOnly {
    override val wirelessGatewayId: Option[WirelessGatewayId] = scala
      .Option(impl.wirelessGatewayId())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayId(value)
      )
    override val wirelessGatewayTaskDefinitionId
        : Option[WirelessGatewayTaskDefinitionId] = scala
      .Option(impl.wirelessGatewayTaskDefinitionId())
      .map(value =>
        zio.aws.iotwireless.model.primitives
          .WirelessGatewayTaskDefinitionId(value)
      )
    override val lastUplinkReceivedAt: Option[ISODateTimeString] = scala
      .Option(impl.lastUplinkReceivedAt())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
      )
    override val taskCreatedAt: Option[ISODateTimeString] = scala
      .Option(impl.taskCreatedAt())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
      )
    override val status
        : Option[zio.aws.iotwireless.model.WirelessGatewayTaskStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.iotwireless.model.WirelessGatewayTaskStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse
  ): zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse.ReadOnly =
    new Wrapper(impl)
}
