package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ThingName,
  ThingArn,
  WirelessDeviceName,
  Description,
  WirelessDeviceId,
  WirelessDeviceArn,
  DestinationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetWirelessDeviceResponse(
    `type`: Option[zio.aws.iotwireless.model.WirelessDeviceType] = None,
    name: Option[WirelessDeviceName] = None,
    description: Option[Description] = None,
    destinationName: Option[DestinationName] = None,
    id: Option[WirelessDeviceId] = None,
    arn: Option[WirelessDeviceArn] = None,
    thingName: Option[ThingName] = None,
    thingArn: Option[ThingArn] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANDevice] = None,
    sidewalk: Option[zio.aws.iotwireless.model.SidewalkDevice] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse = {
    import GetWirelessDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => WirelessDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        destinationName.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destinationName)
      .optionallyWith(
        id.map(value => WirelessDeviceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => WirelessDeviceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetWirelessDeviceResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessDeviceResponse.wrap(buildAwsValue())
}
object GetWirelessDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetWirelessDeviceResponse =
      zio.aws.iotwireless.model.GetWirelessDeviceResponse(
        `type`.map(value => value),
        name.map(value => value),
        description.map(value => value),
        destinationName.map(value => value),
        id.map(value => value),
        arn.map(value => value),
        thingName.map(value => value),
        thingArn.map(value => value),
        loRaWAN.map(value => value.asEditable),
        sidewalk.map(value => value.asEditable)
      )
    def `type`: Option[zio.aws.iotwireless.model.WirelessDeviceType]
    def name: Option[WirelessDeviceName]
    def description: Option[Description]
    def destinationName: Option[DestinationName]
    def id: Option[WirelessDeviceId]
    def arn: Option[WirelessDeviceArn]
    def thingName: Option[ThingName]
    def thingArn: Option[ThingArn]
    def loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly]
    def sidewalk: Option[zio.aws.iotwireless.model.SidewalkDevice.ReadOnly]
    def getType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.WirelessDeviceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, WirelessDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDestinationName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destinationName", destinationName)
    def getId: ZIO[Any, AwsError, WirelessDeviceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, WirelessDeviceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getLoRaWAN
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly] =
      AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkDevice.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse
  ) extends zio.aws.iotwireless.model.GetWirelessDeviceResponse.ReadOnly {
    override val `type`: Option[zio.aws.iotwireless.model.WirelessDeviceType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.iotwireless.model.WirelessDeviceType.wrap(value))
    override val name: Option[WirelessDeviceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val destinationName: Option[DestinationName] = scala
      .Option(impl.destinationName())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationName(value))
    override val id: Option[WirelessDeviceId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceId(value)
      )
    override val arn: Option[WirelessDeviceArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceArn(value)
      )
    override val thingName: Option[ThingName] = scala
      .Option(impl.thingName())
      .map(value => zio.aws.iotwireless.model.primitives.ThingName(value))
    override val thingArn: Option[ThingArn] = scala
      .Option(impl.thingArn())
      .map(value => zio.aws.iotwireless.model.primitives.ThingArn(value))
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly] = scala
      .Option(impl.loRaWAN())
      .map(value => zio.aws.iotwireless.model.LoRaWANDevice.wrap(value))
    override val sidewalk
        : Option[zio.aws.iotwireless.model.SidewalkDevice.ReadOnly] = scala
      .Option(impl.sidewalk())
      .map(value => zio.aws.iotwireless.model.SidewalkDevice.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse
  ): zio.aws.iotwireless.model.GetWirelessDeviceResponse.ReadOnly = new Wrapper(
    impl
  )
}
