package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetServiceEndpointRequest(
    serviceType: Option[zio.aws.iotwireless.model.WirelessGatewayServiceType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointRequest = {
    import GetServiceEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointRequest
      .builder()
      .optionallyWith(serviceType.map(value => value.unwrap))(_.serviceType)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetServiceEndpointRequest.ReadOnly =
    zio.aws.iotwireless.model.GetServiceEndpointRequest.wrap(buildAwsValue())
}
object GetServiceEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetServiceEndpointRequest =
      zio.aws.iotwireless.model
        .GetServiceEndpointRequest(serviceType.map(value => value))
    def serviceType
        : Option[zio.aws.iotwireless.model.WirelessGatewayServiceType]
    def getServiceType: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessGatewayServiceType
    ] = AwsError.unwrapOptionField("serviceType", serviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointRequest
  ) extends zio.aws.iotwireless.model.GetServiceEndpointRequest.ReadOnly {
    override val serviceType
        : Option[zio.aws.iotwireless.model.WirelessGatewayServiceType] = scala
      .Option(impl.serviceType())
      .map(value =>
        zio.aws.iotwireless.model.WirelessGatewayServiceType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointRequest
  ): zio.aws.iotwireless.model.GetServiceEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
