package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.Identifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetResourceEventConfigurationRequest(
    identifier: Identifier,
    identifierType: zio.aws.iotwireless.model.IdentifierType,
    partnerType: Option[
      zio.aws.iotwireless.model.EventNotificationPartnerType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationRequest = {
    import GetResourceEventConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationRequest
      .builder()
      .identifier(Identifier.unwrap(identifier): java.lang.String)
      .identifierType(identifierType.unwrap)
      .optionallyWith(partnerType.map(value => value.unwrap))(_.partnerType)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetResourceEventConfigurationRequest.ReadOnly =
    zio.aws.iotwireless.model.GetResourceEventConfigurationRequest
      .wrap(buildAwsValue())
}
object GetResourceEventConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetResourceEventConfigurationRequest =
      zio.aws.iotwireless.model.GetResourceEventConfigurationRequest(
        identifier,
        identifierType,
        partnerType.map(value => value)
      )
    def identifier: Identifier
    def identifierType: zio.aws.iotwireless.model.IdentifierType
    def partnerType
        : Option[zio.aws.iotwireless.model.EventNotificationPartnerType]
    def getIdentifier: ZIO[Any, Nothing, Identifier] = ZIO.succeed(identifier)
    def getIdentifierType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.IdentifierType] =
      ZIO.succeed(identifierType)
    def getPartnerType: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.EventNotificationPartnerType
    ] = AwsError.unwrapOptionField("partnerType", partnerType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationRequest
  ) extends zio.aws.iotwireless.model.GetResourceEventConfigurationRequest.ReadOnly {
    override val identifier: Identifier =
      zio.aws.iotwireless.model.primitives.Identifier(impl.identifier())
    override val identifierType: zio.aws.iotwireless.model.IdentifierType =
      zio.aws.iotwireless.model.IdentifierType.wrap(impl.identifierType())
    override val partnerType
        : Option[zio.aws.iotwireless.model.EventNotificationPartnerType] = scala
      .Option(impl.partnerType())
      .map(value =>
        zio.aws.iotwireless.model.EventNotificationPartnerType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationRequest
  ): zio.aws.iotwireless.model.GetResourceEventConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
