package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetLogLevelsByResourceTypesResponse(
    defaultLogLevel: Option[zio.aws.iotwireless.model.LogLevel] = None,
    wirelessGatewayLogOptions: Option[
      Iterable[zio.aws.iotwireless.model.WirelessGatewayLogOption]
    ] = None,
    wirelessDeviceLogOptions: Option[
      Iterable[zio.aws.iotwireless.model.WirelessDeviceLogOption]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse = {
    import GetLogLevelsByResourceTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse
      .builder()
      .optionallyWith(defaultLogLevel.map(value => value.unwrap))(
        _.defaultLogLevel
      )
      .optionallyWith(
        wirelessGatewayLogOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wirelessGatewayLogOptions)
      .optionallyWith(
        wirelessDeviceLogOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wirelessDeviceLogOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse.ReadOnly =
    zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse
      .wrap(buildAwsValue())
}
object GetLogLevelsByResourceTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse =
      zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse(
        defaultLogLevel.map(value => value),
        wirelessGatewayLogOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        wirelessDeviceLogOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def defaultLogLevel: Option[zio.aws.iotwireless.model.LogLevel]
    def wirelessGatewayLogOptions: Option[
      List[zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly]
    ]
    def wirelessDeviceLogOptions: Option[
      List[zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly]
    ]
    def getDefaultLogLevel
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.LogLevel] =
      AwsError.unwrapOptionField("defaultLogLevel", defaultLogLevel)
    def getWirelessGatewayLogOptions: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "wirelessGatewayLogOptions",
      wirelessGatewayLogOptions
    )
    def getWirelessDeviceLogOptions: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "wirelessDeviceLogOptions",
      wirelessDeviceLogOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse
  ) extends zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse.ReadOnly {
    override val defaultLogLevel: Option[zio.aws.iotwireless.model.LogLevel] =
      scala
        .Option(impl.defaultLogLevel())
        .map(value => zio.aws.iotwireless.model.LogLevel.wrap(value))
    override val wirelessGatewayLogOptions: Option[
      List[zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly]
    ] = scala
      .Option(impl.wirelessGatewayLogOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessGatewayLogOption.wrap(item)
        }.toList
      )
    override val wirelessDeviceLogOptions: Option[
      List[zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly]
    ] = scala
      .Option(impl.wirelessDeviceLogOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessDeviceLogOption.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetLogLevelsByResourceTypesResponse
  ): zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse.ReadOnly =
    new Wrapper(impl)
}
