package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  FirmwareUpdateRole,
  CreatedAt,
  FirmwareUpdateImage,
  FuotaTaskName,
  Description,
  FuotaTaskArn,
  FuotaTaskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetFuotaTaskResponse(
    arn: Option[FuotaTaskArn] = None,
    id: Option[FuotaTaskId] = None,
    status: Option[zio.aws.iotwireless.model.FuotaTaskStatus] = None,
    name: Option[FuotaTaskName] = None,
    description: Option[Description] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo] = None,
    firmwareUpdateImage: Option[FirmwareUpdateImage] = None,
    firmwareUpdateRole: Option[FirmwareUpdateRole] = None,
    createdAt: Option[CreatedAt] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse = {
    import GetFuotaTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse
      .builder()
      .optionallyWith(
        arn.map(value => FuotaTaskArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => FuotaTaskId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        name.map(value => FuotaTaskName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        firmwareUpdateImage.map(value =>
          FirmwareUpdateImage.unwrap(value): java.lang.String
        )
      )(_.firmwareUpdateImage)
      .optionallyWith(
        firmwareUpdateRole.map(value =>
          FirmwareUpdateRole.unwrap(value): java.lang.String
        )
      )(_.firmwareUpdateRole)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetFuotaTaskResponse.ReadOnly =
    zio.aws.iotwireless.model.GetFuotaTaskResponse.wrap(buildAwsValue())
}
object GetFuotaTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetFuotaTaskResponse =
      zio.aws.iotwireless.model.GetFuotaTaskResponse(
        arn.map(value => value),
        id.map(value => value),
        status.map(value => value),
        name.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable),
        firmwareUpdateImage.map(value => value),
        firmwareUpdateRole.map(value => value),
        createdAt.map(value => value)
      )
    def arn: Option[FuotaTaskArn]
    def id: Option[FuotaTaskId]
    def status: Option[zio.aws.iotwireless.model.FuotaTaskStatus]
    def name: Option[FuotaTaskName]
    def description: Option[Description]
    def loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo.ReadOnly]
    def firmwareUpdateImage: Option[FirmwareUpdateImage]
    def firmwareUpdateRole: Option[FirmwareUpdateRole]
    def createdAt: Option[CreatedAt]
    def getArn: ZIO[Any, AwsError, FuotaTaskArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, FuotaTaskId] =
      AwsError.unwrapOptionField("id", id)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.FuotaTaskStatus] =
      AwsError.unwrapOptionField("status", status)
    def getName: ZIO[Any, AwsError, FuotaTaskName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getFirmwareUpdateImage: ZIO[Any, AwsError, FirmwareUpdateImage] =
      AwsError.unwrapOptionField("firmwareUpdateImage", firmwareUpdateImage)
    def getFirmwareUpdateRole: ZIO[Any, AwsError, FirmwareUpdateRole] =
      AwsError.unwrapOptionField("firmwareUpdateRole", firmwareUpdateRole)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse
  ) extends zio.aws.iotwireless.model.GetFuotaTaskResponse.ReadOnly {
    override val arn: Option[FuotaTaskArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskArn(value))
    override val id: Option[FuotaTaskId] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskId(value))
    override val status: Option[zio.aws.iotwireless.model.FuotaTaskStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.iotwireless.model.FuotaTaskStatus.wrap(value))
    override val name: Option[FuotaTaskName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo.ReadOnly] =
      scala
        .Option(impl.loRaWAN())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo.wrap(value)
        )
    override val firmwareUpdateImage: Option[FirmwareUpdateImage] = scala
      .Option(impl.firmwareUpdateImage())
      .map(value =>
        zio.aws.iotwireless.model.primitives.FirmwareUpdateImage(value)
      )
    override val firmwareUpdateRole: Option[FirmwareUpdateRole] = scala
      .Option(impl.firmwareUpdateRole())
      .map(value =>
        zio.aws.iotwireless.model.primitives.FirmwareUpdateRole(value)
      )
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iotwireless.model.primitives.CreatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskResponse
  ): zio.aws.iotwireless.model.GetFuotaTaskResponse.ReadOnly = new Wrapper(impl)
}
