package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  DeviceProfileId,
  DeviceProfileName,
  DeviceProfileArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDeviceProfileResponse(
    arn: Option[DeviceProfileArn] = None,
    name: Option[DeviceProfileName] = None,
    id: Option[DeviceProfileId] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANDeviceProfile] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse = {
    import GetDeviceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse
      .builder()
      .optionallyWith(
        arn.map(value => DeviceProfileArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => DeviceProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => DeviceProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetDeviceProfileResponse.ReadOnly =
    zio.aws.iotwireless.model.GetDeviceProfileResponse.wrap(buildAwsValue())
}
object GetDeviceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetDeviceProfileResponse =
      zio.aws.iotwireless.model.GetDeviceProfileResponse(
        arn.map(value => value),
        name.map(value => value),
        id.map(value => value),
        loRaWAN.map(value => value.asEditable)
      )
    def arn: Option[DeviceProfileArn]
    def name: Option[DeviceProfileName]
    def id: Option[DeviceProfileId]
    def loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly]
    def getArn: ZIO[Any, AwsError, DeviceProfileArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, DeviceProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, DeviceProfileId] =
      AwsError.unwrapOptionField("id", id)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse
  ) extends zio.aws.iotwireless.model.GetDeviceProfileResponse.ReadOnly {
    override val arn: Option[DeviceProfileArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.DeviceProfileArn(value)
      )
    override val name: Option[DeviceProfileName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.DeviceProfileName(value)
      )
    override val id: Option[DeviceProfileId] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotwireless.model.primitives.DeviceProfileId(value))
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly] =
      scala
        .Option(impl.loRaWAN())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANDeviceProfile.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse
  ): zio.aws.iotwireless.model.GetDeviceProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
