package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  RoleArn,
  Expression,
  Description,
  DestinationArn,
  DestinationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDestinationResponse(
    arn: Option[DestinationArn] = None,
    name: Option[DestinationName] = None,
    expression: Option[Expression] = None,
    expressionType: Option[zio.aws.iotwireless.model.ExpressionType] = None,
    description: Option[Description] = None,
    roleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetDestinationResponse = {
    import GetDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetDestinationResponse
      .builder()
      .optionallyWith(
        arn.map(value => DestinationArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => DestinationName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        expression.map(value => Expression.unwrap(value): java.lang.String)
      )(_.expression)
      .optionallyWith(expressionType.map(value => value.unwrap))(
        _.expressionType
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetDestinationResponse.ReadOnly =
    zio.aws.iotwireless.model.GetDestinationResponse.wrap(buildAwsValue())
}
object GetDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetDestinationResponse =
      zio.aws.iotwireless.model.GetDestinationResponse(
        arn.map(value => value),
        name.map(value => value),
        expression.map(value => value),
        expressionType.map(value => value),
        description.map(value => value),
        roleArn.map(value => value)
      )
    def arn: Option[DestinationArn]
    def name: Option[DestinationName]
    def expression: Option[Expression]
    def expressionType: Option[zio.aws.iotwireless.model.ExpressionType]
    def description: Option[Description]
    def roleArn: Option[RoleArn]
    def getArn: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("name", name)
    def getExpression: ZIO[Any, AwsError, Expression] =
      AwsError.unwrapOptionField("expression", expression)
    def getExpressionType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.ExpressionType] =
      AwsError.unwrapOptionField("expressionType", expressionType)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetDestinationResponse
  ) extends zio.aws.iotwireless.model.GetDestinationResponse.ReadOnly {
    override val arn: Option[DestinationArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationArn(value))
    override val name: Option[DestinationName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationName(value))
    override val expression: Option[Expression] = scala
      .Option(impl.expression())
      .map(value => zio.aws.iotwireless.model.primitives.Expression(value))
    override val expressionType
        : Option[zio.aws.iotwireless.model.ExpressionType] = scala
      .Option(impl.expressionType())
      .map(value => zio.aws.iotwireless.model.ExpressionType.wrap(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iotwireless.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetDestinationResponse
  ): zio.aws.iotwireless.model.GetDestinationResponse.ReadOnly = new Wrapper(
    impl
  )
}
