package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  FuotaTaskName,
  FuotaTaskArn,
  FuotaTaskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FuotaTask(
    id: Option[FuotaTaskId] = None,
    arn: Option[FuotaTaskArn] = None,
    name: Option[FuotaTaskName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.FuotaTask = {
    import FuotaTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.FuotaTask
      .builder()
      .optionallyWith(
        id.map(value => FuotaTaskId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => FuotaTaskArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => FuotaTaskName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.FuotaTask.ReadOnly =
    zio.aws.iotwireless.model.FuotaTask.wrap(buildAwsValue())
}
object FuotaTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.FuotaTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.FuotaTask =
      zio.aws.iotwireless.model.FuotaTask(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value)
      )
    def id: Option[FuotaTaskId]
    def arn: Option[FuotaTaskArn]
    def name: Option[FuotaTaskName]
    def getId: ZIO[Any, AwsError, FuotaTaskId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, FuotaTaskArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, FuotaTaskName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.FuotaTask
  ) extends zio.aws.iotwireless.model.FuotaTask.ReadOnly {
    override val id: Option[FuotaTaskId] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskId(value))
    override val arn: Option[FuotaTaskArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskArn(value))
    override val name: Option[FuotaTaskName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.FuotaTask
  ): zio.aws.iotwireless.model.FuotaTask.ReadOnly = new Wrapper(impl)
}
