package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait ExpressionType {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.ExpressionType
}
object ExpressionType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.ExpressionType
  ): zio.aws.iotwireless.model.ExpressionType = value match {
    case software.amazon.awssdk.services.iotwireless.model.ExpressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.ExpressionType.RULE_NAME =>
      val r = RuleName
      r
    case software.amazon.awssdk.services.iotwireless.model.ExpressionType.MQTT_TOPIC =>
      val r = MqttTopic
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.ExpressionType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ExpressionType =
      software.amazon.awssdk.services.iotwireless.model.ExpressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object RuleName extends zio.aws.iotwireless.model.ExpressionType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ExpressionType =
      software.amazon.awssdk.services.iotwireless.model.ExpressionType.RULE_NAME
  }
  case object MqttTopic extends zio.aws.iotwireless.model.ExpressionType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ExpressionType =
      software.amazon.awssdk.services.iotwireless.model.ExpressionType.MQTT_TOPIC
  }
}
