package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ClientRequestToken,
  Description,
  WirelessGatewayName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateWirelessGatewayRequest(
    name: Option[WirelessGatewayName] = None,
    description: Option[Description] = None,
    loRaWAN: zio.aws.iotwireless.model.LoRaWANGateway,
    tags: Option[Iterable[zio.aws.iotwireless.model.Tag]] = None,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayRequest = {
    import CreateWirelessGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayRequest
      .builder()
      .optionallyWith(
        name.map(value => WirelessGatewayName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .loRaWAN(loRaWAN.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateWirelessGatewayRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateWirelessGatewayRequest.wrap(buildAwsValue())
}
object CreateWirelessGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateWirelessGatewayRequest =
      zio.aws.iotwireless.model.CreateWirelessGatewayRequest(
        name.map(value => value),
        description.map(value => value),
        loRaWAN.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value)
      )
    def name: Option[WirelessGatewayName]
    def description: Option[Description]
    def loRaWAN: zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly
    def tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def clientRequestToken: Option[ClientRequestToken]
    def getName: ZIO[Any, AwsError, WirelessGatewayName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly] =
      ZIO.succeed(loRaWAN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayRequest
  ) extends zio.aws.iotwireless.model.CreateWirelessGatewayRequest.ReadOnly {
    override val name: Option[WirelessGatewayName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN: zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly =
      zio.aws.iotwireless.model.LoRaWANGateway.wrap(impl.loRaWAN())
    override val tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayRequest
  ): zio.aws.iotwireless.model.CreateWirelessGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
