package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ClientRequestToken,
  DestinationName,
  Description,
  WirelessDeviceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateWirelessDeviceRequest(
    `type`: zio.aws.iotwireless.model.WirelessDeviceType,
    name: Option[WirelessDeviceName] = None,
    description: Option[Description] = None,
    destinationName: DestinationName,
    clientRequestToken: Option[ClientRequestToken] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANDevice] = None,
    tags: Option[Iterable[zio.aws.iotwireless.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest = {
    import CreateWirelessDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        name.map(value => WirelessDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .destinationName(
        DestinationName.unwrap(destinationName): java.lang.String
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateWirelessDeviceRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateWirelessDeviceRequest.wrap(buildAwsValue())
}
object CreateWirelessDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateWirelessDeviceRequest =
      zio.aws.iotwireless.model.CreateWirelessDeviceRequest(
        `type`,
        name.map(value => value),
        description.map(value => value),
        destinationName,
        clientRequestToken.map(value => value),
        loRaWAN.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def `type`: zio.aws.iotwireless.model.WirelessDeviceType
    def name: Option[WirelessDeviceName]
    def description: Option[Description]
    def destinationName: DestinationName
    def clientRequestToken: Option[ClientRequestToken]
    def loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly]
    def tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def getType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.WirelessDeviceType] =
      ZIO.succeed(`type`)
    def getName: ZIO[Any, AwsError, WirelessDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDestinationName: ZIO[Any, Nothing, DestinationName] =
      ZIO.succeed(destinationName)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getLoRaWAN
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly] =
      AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest
  ) extends zio.aws.iotwireless.model.CreateWirelessDeviceRequest.ReadOnly {
    override val `type`: zio.aws.iotwireless.model.WirelessDeviceType =
      zio.aws.iotwireless.model.WirelessDeviceType.wrap(impl.`type`())
    override val name: Option[WirelessDeviceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val destinationName: DestinationName =
      zio.aws.iotwireless.model.primitives
        .DestinationName(impl.destinationName())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
      )
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly] = scala
      .Option(impl.loRaWAN())
      .map(value => zio.aws.iotwireless.model.LoRaWANDevice.wrap(value))
    override val tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest
  ): zio.aws.iotwireless.model.CreateWirelessDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
