package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ClientRequestToken,
  ServiceProfileName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateServiceProfileRequest(
    name: Option[ServiceProfileName] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANServiceProfile] = None,
    tags: Option[Iterable[zio.aws.iotwireless.model.Tag]] = None,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileRequest = {
    import CreateServiceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileRequest
      .builder()
      .optionallyWith(
        name.map(value => ServiceProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateServiceProfileRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateServiceProfileRequest.wrap(buildAwsValue())
}
object CreateServiceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateServiceProfileRequest =
      zio.aws.iotwireless.model.CreateServiceProfileRequest(
        name.map(value => value),
        loRaWAN.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value)
      )
    def name: Option[ServiceProfileName]
    def loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANServiceProfile.ReadOnly]
    def tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def clientRequestToken: Option[ClientRequestToken]
    def getName: ZIO[Any, AwsError, ServiceProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANServiceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileRequest
  ) extends zio.aws.iotwireless.model.CreateServiceProfileRequest.ReadOnly {
    override val name: Option[ServiceProfileName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ServiceProfileName(value)
      )
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANServiceProfile.ReadOnly] =
      scala
        .Option(impl.loRaWAN())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANServiceProfile.wrap(value)
        )
    override val tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileRequest
  ): zio.aws.iotwireless.model.CreateServiceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
