package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ClientRequestToken,
  Description,
  MulticastGroupName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateMulticastGroupRequest(
    name: Option[MulticastGroupName] = None,
    description: Option[Description] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    loRaWAN: zio.aws.iotwireless.model.LoRaWANMulticast,
    tags: Option[Iterable[zio.aws.iotwireless.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest = {
    import CreateMulticastGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest
      .builder()
      .optionallyWith(
        name.map(value => MulticastGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .loRaWAN(loRaWAN.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateMulticastGroupRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateMulticastGroupRequest.wrap(buildAwsValue())
}
object CreateMulticastGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateMulticastGroupRequest =
      zio.aws.iotwireless.model.CreateMulticastGroupRequest(
        name.map(value => value),
        description.map(value => value),
        clientRequestToken.map(value => value),
        loRaWAN.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[MulticastGroupName]
    def description: Option[Description]
    def clientRequestToken: Option[ClientRequestToken]
    def loRaWAN: zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly
    def tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def getName: ZIO[Any, AwsError, MulticastGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getLoRaWAN: ZIO[
      Any,
      Nothing,
      zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly
    ] = ZIO.succeed(loRaWAN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest
  ) extends zio.aws.iotwireless.model.CreateMulticastGroupRequest.ReadOnly {
    override val name: Option[MulticastGroupName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
      )
    override val loRaWAN: zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly =
      zio.aws.iotwireless.model.LoRaWANMulticast.wrap(impl.loRaWAN())
    override val tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest
  ): zio.aws.iotwireless.model.CreateMulticastGroupRequest.ReadOnly =
    new Wrapper(impl)
}
