package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  FirmwareUpdateRole,
  ClientRequestToken,
  FirmwareUpdateImage,
  FuotaTaskName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFuotaTaskRequest(
    name: Option[FuotaTaskName] = None,
    description: Option[Description] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANFuotaTask] = None,
    firmwareUpdateImage: FirmwareUpdateImage,
    firmwareUpdateRole: FirmwareUpdateRole,
    tags: Option[Iterable[zio.aws.iotwireless.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest = {
    import CreateFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest
      .builder()
      .optionallyWith(
        name.map(value => FuotaTaskName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .firmwareUpdateImage(
        FirmwareUpdateImage.unwrap(firmwareUpdateImage): java.lang.String
      )
      .firmwareUpdateRole(
        FirmwareUpdateRole.unwrap(firmwareUpdateRole): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.CreateFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateFuotaTaskRequest.wrap(buildAwsValue())
}
object CreateFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateFuotaTaskRequest =
      zio.aws.iotwireless.model.CreateFuotaTaskRequest(
        name.map(value => value),
        description.map(value => value),
        clientRequestToken.map(value => value),
        loRaWAN.map(value => value.asEditable),
        firmwareUpdateImage,
        firmwareUpdateRole,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[FuotaTaskName]
    def description: Option[Description]
    def clientRequestToken: Option[ClientRequestToken]
    def loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly]
    def firmwareUpdateImage: FirmwareUpdateImage
    def firmwareUpdateRole: FirmwareUpdateRole
    def tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def getName: ZIO[Any, AwsError, FuotaTaskName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getFirmwareUpdateImage: ZIO[Any, Nothing, FirmwareUpdateImage] =
      ZIO.succeed(firmwareUpdateImage)
    def getFirmwareUpdateRole: ZIO[Any, Nothing, FirmwareUpdateRole] =
      ZIO.succeed(firmwareUpdateRole)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.CreateFuotaTaskRequest.ReadOnly {
    override val name: Option[FuotaTaskName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
      )
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly] = scala
      .Option(impl.loRaWAN())
      .map(value => zio.aws.iotwireless.model.LoRaWANFuotaTask.wrap(value))
    override val firmwareUpdateImage: FirmwareUpdateImage =
      zio.aws.iotwireless.model.primitives
        .FirmwareUpdateImage(impl.firmwareUpdateImage())
    override val firmwareUpdateRole: FirmwareUpdateRole =
      zio.aws.iotwireless.model.primitives
        .FirmwareUpdateRole(impl.firmwareUpdateRole())
    override val tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest
  ): zio.aws.iotwireless.model.CreateFuotaTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
