package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ClientRequestToken,
  DeviceProfileName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDeviceProfileRequest(
    name: Option[DeviceProfileName] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANDeviceProfile] = None,
    tags: Option[Iterable[zio.aws.iotwireless.model.Tag]] = None,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest = {
    import CreateDeviceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest
      .builder()
      .optionallyWith(
        name.map(value => DeviceProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateDeviceProfileRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateDeviceProfileRequest.wrap(buildAwsValue())
}
object CreateDeviceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateDeviceProfileRequest =
      zio.aws.iotwireless.model.CreateDeviceProfileRequest(
        name.map(value => value),
        loRaWAN.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value)
      )
    def name: Option[DeviceProfileName]
    def loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly]
    def tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def clientRequestToken: Option[ClientRequestToken]
    def getName: ZIO[Any, AwsError, DeviceProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest
  ) extends zio.aws.iotwireless.model.CreateDeviceProfileRequest.ReadOnly {
    override val name: Option[DeviceProfileName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.DeviceProfileName(value)
      )
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly] =
      scala
        .Option(impl.loRaWAN())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANDeviceProfile.wrap(value)
        )
    override val tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest
  ): zio.aws.iotwireless.model.CreateDeviceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
