package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionStatus {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.ConnectionStatus
}
object ConnectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.ConnectionStatus
  ): zio.aws.iotwireless.model.ConnectionStatus = value match {
    case software.amazon.awssdk.services.iotwireless.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.ConnectionStatus.CONNECTED =>
      val r = Connected
      r
    case software.amazon.awssdk.services.iotwireless.model.ConnectionStatus.DISCONNECTED =>
      val r = Disconnected
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ConnectionStatus =
      software.amazon.awssdk.services.iotwireless.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Connected extends zio.aws.iotwireless.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ConnectionStatus =
      software.amazon.awssdk.services.iotwireless.model.ConnectionStatus.CONNECTED
  }
  case object Disconnected extends zio.aws.iotwireless.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ConnectionStatus =
      software.amazon.awssdk.services.iotwireless.model.ConnectionStatus.DISCONNECTED
  }
}
