package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class WirelessMetadata(
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANSendDataToDevice] = None,
    sidewalk: Option[zio.aws.iotwireless.model.SidewalkSendDataToDevice] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WirelessMetadata = {
    import WirelessMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WirelessMetadata
      .builder()
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.WirelessMetadata.ReadOnly =
    zio.aws.iotwireless.model.WirelessMetadata.wrap(buildAwsValue())
}
object WirelessMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WirelessMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WirelessMetadata =
      zio.aws.iotwireless.model.WirelessMetadata(
        loRaWAN.map(value => value.asEditable),
        sidewalk.map(value => value.asEditable)
      )
    def loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANSendDataToDevice.ReadOnly]
    def sidewalk
        : Option[zio.aws.iotwireless.model.SidewalkSendDataToDevice.ReadOnly]
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANSendDataToDevice.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkSendDataToDevice.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessMetadata
  ) extends zio.aws.iotwireless.model.WirelessMetadata.ReadOnly {
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANSendDataToDevice.ReadOnly] =
      scala
        .Option(impl.loRaWAN())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANSendDataToDevice.wrap(value)
        )
    override val sidewalk
        : Option[zio.aws.iotwireless.model.SidewalkSendDataToDevice.ReadOnly] =
      scala
        .Option(impl.sidewalk())
        .map(value =>
          zio.aws.iotwireless.model.SidewalkSendDataToDevice.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessMetadata
  ): zio.aws.iotwireless.model.WirelessMetadata.ReadOnly = new Wrapper(impl)
}
