package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayId,
  WirelessGatewayName,
  NetId,
  Description,
  JoinEui
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateWirelessGatewayRequest(
    id: WirelessGatewayId,
    name: Option[WirelessGatewayName] = None,
    description: Option[Description] = None,
    joinEuiFilters: Option[Iterable[Iterable[JoinEui]]] = None,
    netIdFilters: Option[Iterable[NetId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest = {
    import UpdateWirelessGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest
      .builder()
      .id(WirelessGatewayId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => WirelessGatewayName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        joinEuiFilters.map(value =>
          value.map { item =>
            item.map { item =>
              JoinEui.unwrap(item): java.lang.String
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.joinEuiFilters)
      .optionallyWith(
        netIdFilters.map(value =>
          value.map { item =>
            NetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.netIdFilters)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateWirelessGatewayRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateWirelessGatewayRequest.wrap(buildAwsValue())
}
object UpdateWirelessGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateWirelessGatewayRequest =
      zio.aws.iotwireless.model.UpdateWirelessGatewayRequest(
        id,
        name.map(value => value),
        description.map(value => value),
        joinEuiFilters.map(value => value),
        netIdFilters.map(value => value)
      )
    def id: WirelessGatewayId
    def name: Option[WirelessGatewayName]
    def description: Option[Description]
    def joinEuiFilters: Option[List[List[JoinEui]]]
    def netIdFilters: Option[List[NetId]]
    def getId: ZIO[Any, Nothing, WirelessGatewayId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, WirelessGatewayName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getJoinEuiFilters: ZIO[Any, AwsError, List[List[JoinEui]]] =
      AwsError.unwrapOptionField("joinEuiFilters", joinEuiFilters)
    def getNetIdFilters: ZIO[Any, AwsError, List[NetId]] =
      AwsError.unwrapOptionField("netIdFilters", netIdFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest
  ) extends zio.aws.iotwireless.model.UpdateWirelessGatewayRequest.ReadOnly {
    override val id: WirelessGatewayId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayId(impl.id())
    override val name: Option[WirelessGatewayName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val joinEuiFilters: Option[List[List[JoinEui]]] = scala
      .Option(impl.joinEuiFilters())
      .map(value =>
        value.asScala.map { item =>
          item.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.JoinEui(item)
          }.toList
        }.toList
      )
    override val netIdFilters: Option[List[NetId]] = scala
      .Option(impl.netIdFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.primitives.NetId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest
  ): zio.aws.iotwireless.model.UpdateWirelessGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
