package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  Description,
  MulticastGroupName,
  MulticastGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateMulticastGroupRequest(
    id: MulticastGroupId,
    name: Option[MulticastGroupName] = None,
    description: Option[Description] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANMulticast] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest = {
    import UpdateMulticastGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest
      .builder()
      .id(MulticastGroupId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => MulticastGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateMulticastGroupRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateMulticastGroupRequest.wrap(buildAwsValue())
}
object UpdateMulticastGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateMulticastGroupRequest =
      zio.aws.iotwireless.model.UpdateMulticastGroupRequest(
        id,
        name.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable)
      )
    def id: MulticastGroupId
    def name: Option[MulticastGroupName]
    def description: Option[Description]
    def loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly]
    def getId: ZIO[Any, Nothing, MulticastGroupId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, MulticastGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest
  ) extends zio.aws.iotwireless.model.UpdateMulticastGroupRequest.ReadOnly {
    override val id: MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId(impl.id())
    override val name: Option[MulticastGroupName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly] = scala
      .Option(impl.loRaWAN())
      .map(value => zio.aws.iotwireless.model.LoRaWANMulticast.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateMulticastGroupRequest
  ): zio.aws.iotwireless.model.UpdateMulticastGroupRequest.ReadOnly =
    new Wrapper(impl)
}
