package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  RoleArn,
  Description,
  Expression,
  DestinationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDestinationRequest(
    name: DestinationName,
    expressionType: Option[zio.aws.iotwireless.model.ExpressionType] = None,
    expression: Option[Expression] = None,
    description: Option[Description] = None,
    roleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateDestinationRequest = {
    import UpdateDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateDestinationRequest
      .builder()
      .name(DestinationName.unwrap(name): java.lang.String)
      .optionallyWith(expressionType.map(value => value.unwrap))(
        _.expressionType
      )
      .optionallyWith(
        expression.map(value => Expression.unwrap(value): java.lang.String)
      )(_.expression)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.UpdateDestinationRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateDestinationRequest.wrap(buildAwsValue())
}
object UpdateDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateDestinationRequest =
      zio.aws.iotwireless.model.UpdateDestinationRequest(
        name,
        expressionType.map(value => value),
        expression.map(value => value),
        description.map(value => value),
        roleArn.map(value => value)
      )
    def name: DestinationName
    def expressionType: Option[zio.aws.iotwireless.model.ExpressionType]
    def expression: Option[Expression]
    def description: Option[Description]
    def roleArn: Option[RoleArn]
    def getName: ZIO[Any, Nothing, DestinationName] = ZIO.succeed(name)
    def getExpressionType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.ExpressionType] =
      AwsError.unwrapOptionField("expressionType", expressionType)
    def getExpression: ZIO[Any, AwsError, Expression] =
      AwsError.unwrapOptionField("expression", expression)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateDestinationRequest
  ) extends zio.aws.iotwireless.model.UpdateDestinationRequest.ReadOnly {
    override val name: DestinationName =
      zio.aws.iotwireless.model.primitives.DestinationName(impl.name())
    override val expressionType
        : Option[zio.aws.iotwireless.model.ExpressionType] = scala
      .Option(impl.expressionType())
      .map(value => zio.aws.iotwireless.model.ExpressionType.wrap(value))
    override val expression: Option[Expression] = scala
      .Option(impl.expression())
      .map(value => zio.aws.iotwireless.model.primitives.Expression(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iotwireless.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateDestinationRequest
  ): zio.aws.iotwireless.model.UpdateDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
