package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait SigningAlg {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.SigningAlg
}
object SigningAlg {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.SigningAlg
  ): zio.aws.iotwireless.model.SigningAlg = value match {
    case software.amazon.awssdk.services.iotwireless.model.SigningAlg.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.SigningAlg.ED25519 =>
      val r = Ed25519
      r
    case software.amazon.awssdk.services.iotwireless.model.SigningAlg.P256_R1 =>
      val r = P256r1
      r
  }
  case object unknownToSdkVersion extends zio.aws.iotwireless.model.SigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SigningAlg =
      software.amazon.awssdk.services.iotwireless.model.SigningAlg.UNKNOWN_TO_SDK_VERSION
  }
  case object Ed25519 extends zio.aws.iotwireless.model.SigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SigningAlg =
      software.amazon.awssdk.services.iotwireless.model.SigningAlg.ED25519
  }
  case object P256r1 extends zio.aws.iotwireless.model.SigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SigningAlg =
      software.amazon.awssdk.services.iotwireless.model.SigningAlg.P256_R1
  }
}
